/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.inject.Singleton;
import javax.ws.rs.core.Link;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.Tokenizer;
import org.glassfish.jersey.message.internal.JerseyLink;
import org.glassfish.jersey.message.internal.Utils;
import org.glassfish.jersey.spi.HeaderDelegateProvider;

@Singleton
public class LinkProvider
implements HeaderDelegateProvider<Link> {
    @Override
    public boolean supports(Class<?> type) {
        return Link.class.isAssignableFrom(type);
    }

    public Link fromString(String value) throws IllegalArgumentException {
        return LinkProvider.initBuilder(new JerseyLink.Builder(), value).build(new Object[0]);
    }

    static JerseyLink.Builder initBuilder(JerseyLink.Builder lb, String value) {
        Utils.throwIllegalArgumentExceptionIfNull(value, LocalizationMessages.LINK_IS_NULL());
        StringTokenizer st = new StringTokenizer(value.trim(), "<>;=\"", true);
        try {
            LinkProvider.checkToken(st, "<");
            lb.uri(st.nextToken().trim());
            LinkProvider.checkToken(st, ">");
            while (st.hasMoreTokens()) {
                LinkProvider.checkToken(st, ";");
                String n = st.nextToken().trim();
                LinkProvider.checkToken(st, "=");
                LinkProvider.checkToken(st, "\"");
                String v = st.nextToken();
                LinkProvider.checkToken(st, "\"");
                lb.param(n, v);
            }
        }
        catch (Throwable e) {
            lb = null;
        }
        if (lb == null) {
            throw new IllegalArgumentException("Unable to parse link " + value);
        }
        return lb;
    }

    private static void checkToken(StringTokenizer st, String expected) throws AssertionError {
        String token;
        while ((token = st.nextToken().trim()).length() == 0) {
        }
        if (!token.equals(expected)) {
            throw new AssertionError((Object)("Expected token " + expected + " but found " + token));
        }
    }

    public String toString(Link value) {
        return LinkProvider.stringfy(value);
    }

    static String stringfy(Link value) {
        Utils.throwIllegalArgumentExceptionIfNull(value, LocalizationMessages.LINK_IS_NULL());
        Map map = value.getParams();
        StringBuilder sb = new StringBuilder();
        sb.append('<').append(value.getUri()).append('>');
        for (Map.Entry entry : map.entrySet()) {
            sb.append("; ").append((String)entry.getKey()).append("=\"").append((String)entry.getValue()).append("\"");
        }
        return sb.toString();
    }

    static List<String> getLinkRelations(String rel) {
        return rel == null ? null : Arrays.asList(Tokenizer.tokenize(rel, "\" "));
    }
}

