/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.KeyComparator;
import org.glassfish.jersey.internal.util.KeyComparatorHashMap;
import org.glassfish.jersey.internal.util.KeyComparatorLinkedHashMap;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.message.internal.ReaderInterceptorExecutor;
import org.glassfish.jersey.message.internal.WriterInterceptorExecutor;
import org.jvnet.hk2.annotations.Optional;

public class MessageBodyFactory
implements MessageBodyWorkers {
    public static final KeyComparator<MediaType> MEDIA_TYPE_COMPARATOR = new KeyComparator<MediaType>(){
        private static final long serialVersionUID = 2727819828630827763L;

        @Override
        public boolean equals(MediaType x, MediaType y) {
            return x.getType().equalsIgnoreCase(y.getType()) && x.getSubtype().equalsIgnoreCase(y.getSubtype());
        }

        @Override
        public int hash(MediaType k) {
            return k.getType().toLowerCase().hashCode() + k.getSubtype().toLowerCase().hashCode();
        }

        @Override
        public int compare(MediaType o1, MediaType o2) {
            if (this.equals(o1, o2)) {
                return 0;
            }
            if (o1.isWildcardType() ^ o2.isWildcardType()) {
                return o1.isWildcardType() ? 1 : -1;
            }
            if (o1.isWildcardSubtype() ^ o2.isWildcardSubtype()) {
                return o1.isWildcardSubtype() ? 1 : -1;
            }
            return 0;
        }
    };
    private static final Comparator<MessageBodyWorkerPair<?>> WORKER_BY_TYPE_COMPARATOR = new Comparator<MessageBodyWorkerPair<?>>(){

        @Override
        public int compare(MessageBodyWorkerPair<?> o1, MessageBodyWorkerPair<?> o2) {
            Class o2ProviderClassParam;
            Class o1ProviderClassParam = ((MessageBodyWorkerPair)o1).providerClassParam;
            if (o1ProviderClassParam == (o2ProviderClassParam = ((MessageBodyWorkerPair)o2).providerClassParam)) {
                return this.compare(((MessageBodyWorkerPair)o2).types, ((MessageBodyWorkerPair)o1).types);
            }
            if (o1ProviderClassParam.isAssignableFrom(o2ProviderClassParam)) {
                return 1;
            }
            if (o2ProviderClassParam.isAssignableFrom(o1ProviderClassParam)) {
                return -1;
            }
            return 0;
        }

        @Override
        private int compare(List<MediaType> mediaTypeList1, List<MediaType> mediaTypeList2) {
            mediaTypeList1 = mediaTypeList1.isEmpty() ? MediaTypes.GENERAL_MEDIA_TYPE_LIST : mediaTypeList1;
            mediaTypeList2 = mediaTypeList2.isEmpty() ? MediaTypes.GENERAL_MEDIA_TYPE_LIST : mediaTypeList2;
            return MediaTypes.MEDIA_TYPE_LIST_COMPARATOR.compare(mediaTypeList2, mediaTypeList1);
        }
    };
    private final ServiceLocator locator;
    private final Boolean legacyProviderOrdering;
    private List<MessageBodyWorkerPair<MessageBodyReader>> readers;
    private List<MessageBodyWorkerPair<MessageBodyWriter>> writers;
    private final Map<MediaType, List<MessageBodyReader>> readersCache = new KeyComparatorHashMap<MediaType, List<MessageBodyReader>>(MEDIA_TYPE_COMPARATOR);
    private final Map<MediaType, List<MessageBodyWriter>> writersCache = new KeyComparatorHashMap<MediaType, List<MessageBodyWriter>>(MEDIA_TYPE_COMPARATOR);
    private final Map<Class<?>, List<MessageBodyReader>> mbrTypeLookupCache = new ConcurrentHashMap();
    private final Map<Class<?>, List<MessageBodyWriter>> mbwTypeLookupCache = new ConcurrentHashMap();
    private final Map<Class<?>, List<MediaType>> typeToMediaTypeReadersCache = new ConcurrentHashMap();
    private final Map<Class<?>, List<MediaType>> typeToMediaTypeWritersCache = new ConcurrentHashMap();
    private final Map<TypeMediaTypePair, List<MessageBodyWorkerPair<MessageBodyReader>>> mbrLookupCache = new ConcurrentHashMap<TypeMediaTypePair, List<MessageBodyWorkerPair<MessageBodyReader>>>();
    private final Map<TypeMediaTypePair, List<MessageBodyWorkerPair<MessageBodyWriter>>> mbwLookupCache = new ConcurrentHashMap<TypeMediaTypePair, List<MessageBodyWorkerPair<MessageBodyWriter>>>();

    @Inject
    public MessageBodyFactory(ServiceLocator locator, @Optional Configuration configuration) {
        this.locator = locator;
        this.legacyProviderOrdering = configuration != null && PropertiesHelper.isProperty(configuration.getProperty("jersey.config.workers.legacyOrdering"));
        this.initReaders();
        this.initWriters();
    }

    private void initReaders() {
        this.readers = new ArrayList<MessageBodyWorkerPair<MessageBodyReader>>();
        Set<MessageBodyReader> customProviders = Providers.getCustomProviders(this.locator, MessageBodyReader.class);
        Set<MessageBodyReader> providers = Providers.getProviders(this.locator, MessageBodyReader.class);
        this.initReaders(this.readers, customProviders, true);
        providers.removeAll(customProviders);
        this.initReaders(this.readers, providers, false);
        if (this.legacyProviderOrdering.booleanValue()) {
            Collections.sort(this.readers, new LegacyWorkerComparator(MessageBodyReader.class));
            for (MessageBodyWorkerPair<MessageBodyReader> messageBodyWorkerPair : this.readers) {
                for (MediaType mt : ((MessageBodyWorkerPair)messageBodyWorkerPair).types) {
                    List<MessageBodyReader> readerList = this.readersCache.get(mt);
                    if (readerList == null) {
                        readerList = new ArrayList<MessageBodyReader>();
                        this.readersCache.put(mt, readerList);
                    }
                    readerList.add((MessageBodyReader)((MessageBodyWorkerPair)messageBodyWorkerPair).provider);
                }
            }
        }
    }

    private void initReaders(List<MessageBodyWorkerPair<MessageBodyReader>> readers, Set<MessageBodyReader> providersSet, boolean custom) {
        for (MessageBodyReader provider : providersSet) {
            List<MediaType> values = MediaTypes.createFrom(provider.getClass().getAnnotation(Consumes.class));
            readers.add(new MessageBodyWorkerPair<MessageBodyReader>(provider, values, custom, true));
        }
    }

    private void initWriters() {
        this.writers = new ArrayList<MessageBodyWorkerPair<MessageBodyWriter>>();
        Set<MessageBodyWriter> customProviders = Providers.getCustomProviders(this.locator, MessageBodyWriter.class);
        Set<MessageBodyWriter> providers = Providers.getProviders(this.locator, MessageBodyWriter.class);
        this.initWriters(this.writers, customProviders, true);
        providers.removeAll(customProviders);
        this.initWriters(this.writers, providers, false);
        if (this.legacyProviderOrdering.booleanValue()) {
            Collections.sort(this.writers, new LegacyWorkerComparator(MessageBodyWriter.class));
            for (MessageBodyWorkerPair<MessageBodyWriter> messageBodyWorkerPair : this.writers) {
                for (MediaType mt : ((MessageBodyWorkerPair)messageBodyWorkerPair).types) {
                    List<MessageBodyWriter> writerList = this.writersCache.get(mt);
                    if (writerList == null) {
                        writerList = new ArrayList<MessageBodyWriter>();
                        this.writersCache.put(mt, writerList);
                    }
                    writerList.add((MessageBodyWriter)((MessageBodyWorkerPair)messageBodyWorkerPair).provider);
                }
            }
        }
    }

    private void initWriters(List<MessageBodyWorkerPair<MessageBodyWriter>> writers, Set<MessageBodyWriter> providersSet, boolean custom) {
        for (MessageBodyWriter provider : providersSet) {
            List<MediaType> values = MediaTypes.createFrom(provider.getClass().getAnnotation(Produces.class));
            writers.add(new MessageBodyWorkerPair<MessageBodyWriter>(provider, values, custom, false));
        }
    }

    @Override
    public Map<MediaType, List<MessageBodyReader>> getReaders(MediaType mediaType) {
        KeyComparatorLinkedHashMap<MediaType, List<MessageBodyReader>> subSet = new KeyComparatorLinkedHashMap<MediaType, List<MessageBodyReader>>(MEDIA_TYPE_COMPARATOR);
        this.getCompatibleProvidersMap(mediaType, this.readers, subSet);
        return subSet;
    }

    @Override
    public Map<MediaType, List<MessageBodyWriter>> getWriters(MediaType mediaType) {
        KeyComparatorLinkedHashMap<MediaType, List<MessageBodyWriter>> subSet = new KeyComparatorLinkedHashMap<MediaType, List<MessageBodyWriter>>(MEDIA_TYPE_COMPARATOR);
        this.getCompatibleProvidersMap(mediaType, this.writers, subSet);
        return subSet;
    }

    @Override
    public String readersToString(Map<MediaType, List<MessageBodyReader>> readers) {
        return this.toString(readers);
    }

    @Override
    public String writersToString(Map<MediaType, List<MessageBodyWriter>> writers) {
        return this.toString(writers);
    }

    private <T> String toString(Map<MediaType, List<T>> set) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (Map.Entry<MediaType, List<T>> e : set.entrySet()) {
            pw.append(e.getKey().toString()).println(" ->");
            for (T t : e.getValue()) {
                pw.append("  ").println(t.getClass().getName());
            }
        }
        pw.flush();
        return sw.toString();
    }

    @Override
    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType mediaType) {
        MessageBodyReader<T> p = null;
        if (this.legacyProviderOrdering.booleanValue()) {
            if (mediaType != null && (p = this._getMessageBodyReader(c, t, as, mediaType, mediaType)) == null) {
                p = this._getMessageBodyReader(c, t, as, mediaType, MediaTypes.getTypeWildCart(mediaType));
            }
            if (p == null) {
                p = this._getMessageBodyReader(c, t, as, mediaType, MediaTypes.GENERAL_MEDIA_TYPE);
            }
        } else {
            p = this._getMessageBodyReader(c, t, as, mediaType, this.readers);
        }
        return p;
    }

    @Override
    public List<MediaType> getMessageBodyReaderMediaTypes(Class<?> type, Type genericType, Annotation[] annotations) {
        LinkedHashSet readableMediaTypes = Sets.newLinkedHashSet();
        for (MessageBodyWorkerPair<MessageBodyReader> mbrp : this.readers) {
            boolean readableWorker = false;
            for (MediaType mt : ((MessageBodyWorkerPair)mbrp).types) {
                if (((MessageBodyReader)((MessageBodyWorkerPair)mbrp).provider).isReadable(type, genericType, annotations, mt)) {
                    readableMediaTypes.add(mt);
                    readableWorker = true;
                }
                if (readableMediaTypes.contains(MediaType.WILDCARD_TYPE) || !readableWorker || !((MessageBodyWorkerPair)mbrp).types.contains(MediaType.WILDCARD_TYPE)) continue;
                readableMediaTypes.add(MediaType.WILDCARD_TYPE);
            }
        }
        ArrayList mtl = Lists.newArrayList((Iterable)readableMediaTypes);
        Collections.sort(mtl, MediaTypes.MEDIA_TYPE_COMPARATOR);
        return mtl;
    }

    private <T> boolean isCompatible(MessageBodyWorkerPair<T> messageBodyWorkerPair, Class c, MediaType mediaType) {
        if (((MessageBodyWorkerPair)messageBodyWorkerPair).providerClassParam.equals(Object.class) || ((MessageBodyWorkerPair)messageBodyWorkerPair).providerClassParam.isAssignableFrom(c) || c.isAssignableFrom(((MessageBodyWorkerPair)messageBodyWorkerPair).providerClassParam)) {
            for (MediaType mt : ((MessageBodyWorkerPair)messageBodyWorkerPair).types) {
                if (mediaType == null) {
                    return true;
                }
                if (!MediaTypes.typeEqual(mediaType, mt) && !MediaTypes.typeEqual(MediaTypes.getTypeWildCart(mediaType), mt) && !MediaTypes.typeEqual(MediaTypes.GENERAL_MEDIA_TYPE, mt)) continue;
                return true;
            }
        }
        return false;
    }

    private <T> MessageBodyReader<T> _getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType mediaType, List<MessageBodyWorkerPair<MessageBodyReader>> workers) {
        List<MessageBodyWorkerPair<MessageBodyReader>> readers = this.mbrLookupCache.get(new TypeMediaTypePair(c, mediaType));
        if (readers == null) {
            readers = new ArrayList<MessageBodyWorkerPair<MessageBodyReader>>();
            for (MessageBodyWorkerPair<MessageBodyReader> mbwp : workers) {
                if (!this.isCompatible(mbwp, c, mediaType)) continue;
                readers.add(mbwp);
            }
            Collections.sort(readers, new WorkerComparator(c, mediaType));
            this.mbrLookupCache.put(new TypeMediaTypePair(c, mediaType), readers);
        }
        if (readers.isEmpty()) {
            return null;
        }
        for (MessageBodyWorkerPair<MessageBodyReader> mbwp : readers) {
            if (!((MessageBodyReader)((MessageBodyWorkerPair)mbwp).provider).isReadable(c, t, as, mediaType)) continue;
            return (MessageBodyReader)((MessageBodyWorkerPair)mbwp).provider;
        }
        return null;
    }

    private <T> MessageBodyReader<T> _getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType mediaType, MediaType lookup) {
        List<MessageBodyReader> readers = this.readersCache.get(lookup);
        if (readers == null) {
            return null;
        }
        for (MessageBodyReader p : readers) {
            if (!p.isReadable(c, t, as, mediaType)) continue;
            return p;
        }
        return null;
    }

    @Override
    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> c, Type t, Annotation[] as, MediaType mediaType) {
        MessageBodyWriter<T> p = null;
        if (this.legacyProviderOrdering.booleanValue()) {
            if (mediaType != null && (p = this._getMessageBodyWriter(c, t, as, mediaType, mediaType)) == null) {
                p = this._getMessageBodyWriter(c, t, as, mediaType, MediaTypes.getTypeWildCart(mediaType));
            }
            if (p == null) {
                p = this._getMessageBodyWriter(c, t, as, mediaType, MediaTypes.GENERAL_MEDIA_TYPE);
            }
        } else {
            p = this._getMessageBodyWriter(c, t, as, mediaType, this.writers);
        }
        return p;
    }

    private <T> MessageBodyWriter<T> _getMessageBodyWriter(Class<T> c, Type t, Annotation[] as, MediaType mediaType, List<MessageBodyWorkerPair<MessageBodyWriter>> workers) {
        List<MessageBodyWorkerPair<MessageBodyWriter>> writers = this.mbwLookupCache.get(new TypeMediaTypePair(c, mediaType));
        if (writers == null) {
            writers = new ArrayList<MessageBodyWorkerPair<MessageBodyWriter>>();
            for (MessageBodyWorkerPair<MessageBodyWriter> mbwp : workers) {
                if (!this.isCompatible(mbwp, c, mediaType)) continue;
                writers.add(mbwp);
            }
            Collections.sort(writers, new WorkerComparator(c, mediaType));
            this.mbwLookupCache.put(new TypeMediaTypePair(c, mediaType), writers);
        }
        if (writers.isEmpty()) {
            return null;
        }
        for (MessageBodyWorkerPair<MessageBodyWriter> mbwp : writers) {
            if (!((MessageBodyWriter)((MessageBodyWorkerPair)mbwp).provider).isWriteable(c, t, as, mediaType)) continue;
            return (MessageBodyWriter)((MessageBodyWorkerPair)mbwp).provider;
        }
        return null;
    }

    private <T> MessageBodyWriter<T> _getMessageBodyWriter(Class<T> c, Type t, Annotation[] as, MediaType mediaType, MediaType lookup) {
        List<MessageBodyWriter> writers = this.writersCache.get(lookup);
        if (writers == null) {
            return null;
        }
        for (MessageBodyWriter p : writers) {
            if (!p.isWriteable(c, t, as, mediaType)) continue;
            return p;
        }
        return null;
    }

    private <T> void getCompatibleProvidersMap(MediaType mediaType, List<MessageBodyWorkerPair<T>> set, Map<MediaType, List<T>> subSet) {
        if (mediaType.isWildcardType()) {
            this.getCompatibleProvidersList(mediaType, set, subSet);
        } else if (mediaType.isWildcardSubtype()) {
            this.getCompatibleProvidersList(mediaType, set, subSet);
            this.getCompatibleProvidersList(MediaTypes.GENERAL_MEDIA_TYPE, set, subSet);
        } else {
            this.getCompatibleProvidersList(mediaType, set, subSet);
            this.getCompatibleProvidersList(MediaTypes.getTypeWildCart(mediaType), set, subSet);
            this.getCompatibleProvidersList(MediaTypes.GENERAL_MEDIA_TYPE, set, subSet);
        }
    }

    private <T> void getCompatibleProvidersList(MediaType mediaType, List<MessageBodyWorkerPair<T>> set, Map<MediaType, List<T>> subSet) {
        ArrayList<Object> providers = new ArrayList<Object>();
        for (MessageBodyWorkerPair<T> mbpp : set) {
            if (!((MessageBodyWorkerPair)mbpp).types.contains(mediaType)) continue;
            providers.add(((MessageBodyWorkerPair)mbpp).provider);
        }
        if (!providers.isEmpty()) {
            subSet.put(mediaType, Collections.unmodifiableList(providers));
        }
    }

    @Override
    public List<MediaType> getMessageBodyWriterMediaTypes(Class<?> c, Type t, Annotation[] as) {
        LinkedHashSet writeableMediaTypes = Sets.newLinkedHashSet();
        for (MessageBodyWorkerPair<MessageBodyWriter> mbwp : this.writers) {
            boolean writeableWorker = false;
            for (MediaType mt : ((MessageBodyWorkerPair)mbwp).types) {
                if (((MessageBodyWriter)((MessageBodyWorkerPair)mbwp).provider).isWriteable(c, t, as, mt)) {
                    writeableMediaTypes.add(mt);
                    writeableWorker = true;
                }
                if (writeableMediaTypes.contains(MediaType.WILDCARD_TYPE) || !writeableWorker || !((MessageBodyWorkerPair)mbwp).types.contains(MediaType.WILDCARD_TYPE)) continue;
                writeableMediaTypes.add(MediaType.WILDCARD_TYPE);
            }
        }
        ArrayList mtl = Lists.newArrayList((Iterable)writeableMediaTypes);
        Collections.sort(mtl, MediaTypes.MEDIA_TYPE_COMPARATOR);
        return mtl;
    }

    @Override
    public List<MessageBodyWriter> getMessageBodyWritersForType(Class<?> clazz) {
        if (!this.mbwTypeLookupCache.containsKey(clazz)) {
            this.processMessageBodyWritersForType(clazz);
        }
        return this.mbwTypeLookupCache.get(clazz);
    }

    private void processMessageBodyWritersForType(Class<?> clazz) {
        ArrayList suitableWriters = Lists.newArrayList();
        if (Response.class.isAssignableFrom(clazz)) {
            suitableWriters.addAll(this.writers);
        } else {
            for (MessageBodyWorkerPair<MessageBodyWriter> workerPair : this.writers) {
                Class wrapped = Primitives.wrap(clazz);
                if (((MessageBodyWorkerPair)workerPair).providerClassParam != null && !((MessageBodyWorkerPair)workerPair).providerClassParam.isAssignableFrom(wrapped) && ((MessageBodyWorkerPair)workerPair).providerClassParam != clazz) continue;
                suitableWriters.add(workerPair);
            }
        }
        this.typeToMediaTypeWritersCache.put(clazz, this.getMessageBodyWorkersMediaTypesByType(suitableWriters));
        Collections.sort(suitableWriters, WORKER_BY_TYPE_COMPARATOR);
        ArrayList writers = Lists.newArrayList();
        for (MessageBodyWorkerPair workerPair : suitableWriters) {
            writers.add(workerPair.provider);
        }
        this.mbwTypeLookupCache.put(clazz, writers);
    }

    @Override
    public List<MediaType> getMessageBodyWriterMediaTypesByType(Class<?> type) {
        if (!this.typeToMediaTypeWritersCache.containsKey(type)) {
            this.processMessageBodyWritersForType(type);
        }
        return this.typeToMediaTypeWritersCache.get(type);
    }

    @Override
    public List<MediaType> getMessageBodyReaderMediaTypesByType(Class<?> type) {
        if (!this.typeToMediaTypeReadersCache.containsKey(type)) {
            this.processMessageBodyReadersForType(type);
        }
        return this.typeToMediaTypeReadersCache.get(type);
    }

    private <T> List<MediaType> getMessageBodyWorkersMediaTypesByType(List<MessageBodyWorkerPair<T>> workers) {
        HashSet mediaTypeSet = Sets.newHashSet();
        for (MessageBodyWorkerPair<T> mbwp : workers) {
            mediaTypeSet.addAll(((MessageBodyWorkerPair)mbwp).types);
        }
        ArrayList mediaTypes = Lists.newArrayList((Iterable)mediaTypeSet);
        Collections.sort(mediaTypes, MediaTypes.MEDIA_TYPE_COMPARATOR);
        return mediaTypes;
    }

    @Override
    public List<MessageBodyReader> getMessageBodyReadersForType(Class<?> clazz) {
        if (!this.mbrTypeLookupCache.containsKey(clazz)) {
            this.processMessageBodyReadersForType(clazz);
        }
        return this.mbrTypeLookupCache.get(clazz);
    }

    private void processMessageBodyReadersForType(Class<?> clazz) {
        ArrayList suitableReaders = Lists.newArrayList();
        for (MessageBodyWorkerPair<MessageBodyReader> workerPair : this.readers) {
            Class wrapped = Primitives.wrap(clazz);
            if (((MessageBodyWorkerPair)workerPair).providerClassParam != null && !((MessageBodyWorkerPair)workerPair).providerClassParam.isAssignableFrom(wrapped) && ((MessageBodyWorkerPair)workerPair).providerClassParam != clazz) continue;
            suitableReaders.add(workerPair);
        }
        this.typeToMediaTypeReadersCache.put(clazz, this.getMessageBodyWorkersMediaTypesByType(suitableReaders));
        Collections.sort(suitableReaders, WORKER_BY_TYPE_COMPARATOR);
        ArrayList readers = Lists.newArrayList();
        for (MessageBodyWorkerPair workerPair : suitableReaders) {
            readers.add(workerPair.provider);
        }
        this.mbrTypeLookupCache.put(clazz, readers);
    }

    @Override
    public MediaType getMessageBodyWriterMediaType(Class<?> c, Type t, Annotation[] as, List<MediaType> acceptableMediaTypes) {
        for (MediaType acceptable : acceptableMediaTypes) {
            for (MessageBodyWorkerPair<MessageBodyWriter> mbwp : this.writers) {
                for (MediaType mt : ((MessageBodyWorkerPair)mbwp).types) {
                    if (!mt.isCompatible(acceptable) || !((MessageBodyWriter)((MessageBodyWorkerPair)mbwp).provider).isWriteable(c, t, as, acceptable)) continue;
                    return MediaTypes.mostSpecific(mt, acceptable);
                }
            }
        }
        return null;
    }

    @Override
    public Object readFrom(Class<?> rawType, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, PropertiesDelegate propertiesDelegate, InputStream entityStream, Iterable<ReaderInterceptor> readerInterceptors, boolean translateNce) throws WebApplicationException, IOException {
        ReaderInterceptorExecutor executor = new ReaderInterceptorExecutor(rawType, type, annotations, mediaType, httpHeaders, propertiesDelegate, entityStream, this, readerInterceptors, translateNce);
        return executor.proceed();
    }

    @Override
    public OutputStream writeTo(Object t, Class<?> rawType, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, PropertiesDelegate propertiesDelegate, OutputStream entityStream, Iterable<WriterInterceptor> writerInterceptors) throws IOException, WebApplicationException {
        WriterInterceptorExecutor executor = new WriterInterceptorExecutor(t, rawType, type, annotations, mediaType, httpHeaders, propertiesDelegate, entityStream, this, writerInterceptors);
        executor.proceed();
        return executor.getOutputStream();
    }

    public static class Binder
    extends AbstractBinder {
        protected void configure() {
            this.bindAsContract(MessageBodyFactory.class).to(MessageBodyWorkers.class).in(Singleton.class);
        }
    }

    private static class DeclarationDistanceComparator<T>
    implements Comparator<T> {
        private final Class<T> declared;
        private final Map<Class, Integer> distanceMap = new HashMap<Class, Integer>();

        DeclarationDistanceComparator(Class<T> declared) {
            this.declared = declared;
        }

        @Override
        public int compare(T o1, T o2) {
            int d1 = this.getDistance(o1);
            int d2 = this.getDistance(o2);
            return d2 - d1;
        }

        private int getDistance(T t) {
            Integer distance = this.distanceMap.get(t.getClass());
            if (distance != null) {
                return distance;
            }
            distance = 0;
            for (Class a = (as = ReflectionHelper.getParameterizedClassArguments(p = ReflectionHelper.getClass(t.getClass(), this.declared))) != null ? as[0] : null; a != null && a != Object.class; a = a.getSuperclass()) {
                Integer n = distance;
                Integer n2 = distance = Integer.valueOf(distance + 1);
            }
            this.distanceMap.put(t.getClass(), distance);
            return distance;
        }
    }

    private static class LegacyWorkerComparator<T>
    implements Comparator<MessageBodyWorkerPair<T>> {
        final DeclarationDistanceComparator<T> distanceComparator;

        private LegacyWorkerComparator(Class<T> type) {
            this.distanceComparator = new DeclarationDistanceComparator<T>(type);
        }

        @Override
        public int compare(MessageBodyWorkerPair<T> mbwp1, MessageBodyWorkerPair<T> mbwp2) {
            if (((MessageBodyWorkerPair)mbwp1).custom ^ ((MessageBodyWorkerPair)mbwp2).custom) {
                return ((MessageBodyWorkerPair)mbwp1).custom != false ? -1 : 1;
            }
            int mediaTypeComparison = MEDIA_TYPE_COMPARATOR.compare(((MessageBodyWorkerPair)mbwp1).types.get(0), ((MessageBodyWorkerPair)mbwp2).types.get(0));
            if (mediaTypeComparison != 0) {
                return mediaTypeComparison;
            }
            return this.distanceComparator.compare(((MessageBodyWorkerPair)mbwp1).provider, ((MessageBodyWorkerPair)mbwp2).provider);
        }
    }

    private static class MessageBodyWorkerPair<T> {
        private final T provider;
        private final List<MediaType> types;
        private final Boolean custom;
        private final Class<?> providerClassParam;

        public MessageBodyWorkerPair(T provider, List<MediaType> types, Boolean custom, Boolean isReader) {
            this.provider = provider;
            this.types = types;
            this.custom = custom;
            this.providerClassParam = this.getProviderClassParam(isReader);
        }

        private Class<?> getProviderClassParam(boolean isReader) {
            ReflectionHelper.DeclaringClassInterfacePair pair = ReflectionHelper.getClass(this.provider.getClass(), isReader ? MessageBodyReader.class : MessageBodyWriter.class);
            Class[] classArgs = ReflectionHelper.getParameterizedClassArguments(pair);
            return classArgs != null ? classArgs[0] : Object.class;
        }
    }

    private static class TypeMediaTypePair {
        final Class<?> clazz;
        final MediaType mediaType;

        private TypeMediaTypePair(Class<?> clazz, MediaType mediaType) {
            this.clazz = clazz;
            this.mediaType = mediaType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeMediaTypePair that = (TypeMediaTypePair)o;
            return !(this.clazz == null ? that.clazz != null : !this.clazz.equals(that.clazz)) && !(this.mediaType == null ? that.mediaType != null : !this.mediaType.equals((Object)that.mediaType));
        }

        public int hashCode() {
            int result = this.clazz != null ? this.clazz.hashCode() : 0;
            result = 31 * result + (this.mediaType != null ? this.mediaType.hashCode() : 0);
            return result;
        }
    }

    private static class WorkerComparator<T>
    implements Comparator<MessageBodyWorkerPair<T>> {
        final Class wantedType;
        final MediaType wantedMediaType;

        private WorkerComparator(Class wantedType, MediaType wantedMediaType) {
            this.wantedType = wantedType;
            this.wantedMediaType = wantedMediaType;
        }

        @Override
        public int compare(MessageBodyWorkerPair<T> mbwp1, MessageBodyWorkerPair<T> mbwp2) {
            int distance = this.compareTypeDistances(((MessageBodyWorkerPair)mbwp1).providerClassParam, ((MessageBodyWorkerPair)mbwp2).providerClassParam);
            if (distance != 0) {
                return distance;
            }
            int mediaTypeComparison = this.getMediaTypeDistance(this.wantedMediaType, ((MessageBodyWorkerPair)mbwp1).types) - this.getMediaTypeDistance(this.wantedMediaType, ((MessageBodyWorkerPair)mbwp2).types);
            if (mediaTypeComparison != 0) {
                return mediaTypeComparison;
            }
            if (((MessageBodyWorkerPair)mbwp1).custom ^ ((MessageBodyWorkerPair)mbwp2).custom) {
                return ((MessageBodyWorkerPair)mbwp1).custom != false ? -1 : 1;
            }
            return 0;
        }

        private int getMediaTypeDistance(MediaType wanted, List<MediaType> mtl) {
            if (wanted == null) {
                return 0;
            }
            int distance = 2;
            for (MediaType mt : mtl) {
                if (MediaTypes.typeEqual(wanted, mt)) {
                    return 0;
                }
                if (distance <= 1 || !MediaTypes.typeEqual(MediaTypes.getTypeWildCart(wanted), mt)) continue;
                distance = 1;
            }
            return distance;
        }

        private int compareTypeDistances(Class<?> providerClassParam1, Class<?> providerClassParam2) {
            return this.getTypeDistance(providerClassParam1) - this.getTypeDistance(providerClassParam2);
        }

        private int getTypeDistance(Class<?> classParam) {
            Class tmp1 = this.wantedType;
            Class<?> tmp2 = classParam;
            Iterator<Class<?>> it1 = this.getClassHierarchyIterator(tmp1);
            Iterator<Class<?>> it2 = this.getClassHierarchyIterator(tmp2);
            int distance = 0;
            while (!this.wantedType.equals(tmp2) && !classParam.equals(tmp1)) {
                ++distance;
                if (!this.wantedType.equals(tmp2)) {
                    Class<?> clazz = tmp2 = it2.hasNext() ? it2.next() : null;
                }
                if (!classParam.equals(tmp1)) {
                    Class clazz = tmp1 = it1.hasNext() ? it1.next() : null;
                }
                if (tmp2 != null || tmp1 != null) continue;
                return Integer.MAX_VALUE;
            }
            return distance;
        }

        private Iterator<Class<?>> getClassHierarchyIterator(Class<?> classParam) {
            if (classParam == null) {
                return Collections.emptyList().iterator();
            }
            ArrayList<Class> classes = new ArrayList<Class>();
            LinkedList unprocessed = new LinkedList();
            unprocessed.add(classParam);
            while (!unprocessed.isEmpty()) {
                Class clazz = (Class)unprocessed.removeFirst();
                classes.add(clazz);
                unprocessed.addAll(Arrays.asList(clazz.getInterfaces()));
                Class superclazz = clazz.getSuperclass();
                if (superclazz == null) continue;
                unprocessed.add(superclazz);
            }
            return classes.iterator();
        }
    }
}

