<?php
$db = array();
function parseteam($str){
    global $db, $hashes, $teams;
    $row = str_getcsv($str, ';');
    $cnt = count($row);
    if ($cnt < 5)
        return $cnt > 1 ? $row : null;

    // store current hash
    $id = intval($row[1]);
    $str = preg_replace('|;"[0-9a-z]{5}";"http://zlombol.pl/|i', ';"http://zlombol.pl/', $str); // remove mobile app code
    $hash = hash('sha1', strstr($str, ';'));
    $hashes[$id] = $hash;

    // auto update this team?
    if (isset($teams[$id])){
        $t = $teams[$id];
        if ($t['hash'] != $hash){
            echo("Hash (?): #$id (${row[2]}) -> ($hash) $str\n");
        }
        else {
            foreach ($t as $key => $val) {
                if (is_int($key)) 
                    $row[$key] = $val;
            }
        }
    }

    $db[$id] = $row;
    return $row;
}

// mode 'vehicles'
function initvehicles(){
    global $vd, $vg;
    $vd = array(); $vg = array();
}

function addvehicles($i, $row){
    global $vehicles, $vd, $vg;

    list($lp, $id, $team, $vehicle) = $row;
    if (strlen($vehicle) < 1){
        // if (strlen($id) > 0)
            echo("Odd ($i): #$id ($team) -> '$vehicle'\n");
        return false;
    }

    foreach ($vehicles as $v => $item){
        if (!preg_match('/'.$item['regex'].'/ui', $vehicle, $m))
            continue;
        
        if (!isset($vd[$v])) $vd[$v] = array();
        $vd[$v][$id] = $vehicle;

        $v = $item['make'];
        if (!isset($vg[$v])) $vg[$v] = array();
        $vg[$v][$id] = $vehicle;

        return true;
    }

    echo("New ($i): #$id ($team) -> '$vehicle'\n");
    return false;
}

function displayvehicles($arg = null){
    global $vd, $vg, $db, $hashes, $teams;
    sortresults($vd);
    sortresults($vg);

    $vc = 0;
    foreach ($vd as $v => $l){
        $c = count($l);
        if ($arg == 'extra')
            echo("$v;$c;\"".implode('";"', $l)."\"\n");
        else
            echo("$v;$c\n");
        $vc += $c;
    }
    echo("total;$vc;".count($vd)."\n\n");
    
    $vc = 0;
    foreach ($vg as $v => $l){
        $c = count($l);
        if ($arg == 'extra')
            echo("$v;$c;\"".implode('";"', $l)."\"\n");
        else
            echo("$v;$c\n");
        $vc += $c;
    }
    echo("total;$vc;".count($vg)."\n");
    
    // print hashes for '(Niezdecydowani)'
    $nns = isset($vg['(Niezdecydowani)']) ? array_diff(array_keys($vg['(Niezdecydowani)']), array_keys($teams)) : array();
    sort($nns);
    foreach ($nns as $k){
        $id = intval($k);
        printf("    %s => array('hash' => '%s'), // %s\n", $id, @$hashes[$id], $db[$id][2]);
    }
}

// mode 'years'
function inityears(){
    global $cc, $yc, $yr;
    $t = range(2007, date("Y"));
    $cc = array_fill(1, count($t), 0); //number of zlombols
    $yc = array_fill_keys($t, 0); //members in
    $yr = array_fill_keys($t, 0); //returns
}

function addyears($i, $row){
    global $cc, $yc, $yr;
    list(, $id, $team) = $row;
    $tmp = preg_replace('/[^0-9,]/', null, $row[4]);
    if (strlen($tmp) < 4){
        echo("Odd ($i): #$id ($team) -> '$tmp'\n");
        return false;
    }

    $u = array_map('intval', explode(',', $tmp));
    $c = count($u);
    $cc[$c]++;

    foreach ($u as $i => $y){
        if (!isset($yc[$y]))
            var_dump($y, $tmp);
        $yc[$y]++;
    }
    
    if (isset($u[$c-2]) && $u[$c-2] != date("Y") - 1)
        $yr[$u[$c-2]]++;
}

function displayyears($arg = ''){
    global $cc, $yc, $yr;
    unset($yc[0]);
    unset($yc[date("Y")]);
    $yr = array_filter($yr);

    $t = 0;
    foreach ($cc as $i => $c){
        echo("$i;$c\n");
        $t += $c;
    }
    echo("total;$t\n\n");
    
    $t = 0;
    krsort($yc);
    foreach ($yc as $i => $c){
        echo("$i;$c\n");
        $t += $c;
    }
    echo("total;$t\n\n");

    $t = 0;
    krsort($yr);
    foreach ($yr as $i => $c){
        echo("$i;$c\n");
        $t += $c;
    }
    echo("total;$t\n\n");
}

// mode 'regions'
function initregions(){
    global $lc, $lh, $fc, $regions;
    // $lc = array_fill_keys(array_map(function($r){return $r['name'];}, $regions), 0); 
    $lc = array_fill_keys(array_keys($regions), array()); 
    $lh = array();
    $fc = array();
}

function addregions($i, $row){
    global $lc, $lh, $fc, $local, $regions;
    list(, $id, $team) = $row;

    // check region (country)
    $region = trim(@$row[9]);
    if (strlen($region) < 2){
        echo("Country ($i): #$id ($team) -> '".$row[6]."' '".$row[7]."', '".$row[9]."'\n");
        return false;
    }
    else if (!preg_match($local, $region, $m)){
        if (!isset($fc[$region])) $fc[$region] = array();
        $fc[$region][$id] = $team;
    }
    // subregions (Poland)
    else if (strlen(@$row[7]) > 1){
        $h = array();
        $region = trim($row[7]);
        foreach ($regions as $r => $item){
            if (!preg_match('/'.$item['regex'].'/ui', $region, $m))
                continue;

            // add to region members
            $lc[$r][$id] = $m[0];
            
            // multi region match list
            $h[$r] = $m[0]; // $row[7]
        }

        // is it multi match
        $c = count($h);
        if ($c == 0)
            echo("None ($i): #$id ($team) -> '".$row[6]."', '".$row[7]."', '".$row[9]."'\n");
        else if ($c > 1){
            array_unshift($h, $region);
            $lh[$id] = $h;
        }
    }
    else {
        echo("Region ($i): #$id ($team) -> '".$row[6]."' '".$row[7]."', '".$row[9]."'\n");
        return false;
    }
}

function displayregions($arg){
    global $lc, $lh, $fc, $regions;

    $t = 0;
    foreach ($lc as $r => $l){
        $c = count($l);
        if ($c < 1) continue;
        if ($arg == 'extra')
            echo($regions[$r]['name'].";$c;".implode(', ', $l)."\n");
        else
            echo($regions[$r]['name'].";$c\n");

        $t += $c;
    }
    echo("total;$t\n\n");

    $chk = $t;
    foreach ($lh as $id => $l){
        $r = array_shift($l);
        $c = count($l);
        if ($arg == 'extra')
            echo("$id;\"$r\";$c;".@implode(', ', $l)."\n");
        else
            echo("$id;\"$r\";$c\n");

        $chk -= ($c - 1);
    }
    echo("multi;".count($lh)."\n\n");
    
    $t = 0;
    foreach ($fc as $r => $l){
        $c = count($l);
        if ($arg == 'extra')
            echo("$r;$c;".implode(', ', $l)."\n");
        else
            echo("$r;$c\n");
        
        $t += $c;
        $chk += $c;
    }
    echo("total;$t\n");

    echo("\ncheck;$chk\n");
}

function sortresults(&$res){
    $keys = array(); $vals = array();
    foreach ($res as $k => $v){
        $keys[$k] = $k;
        $vals[$k] = count($v);
    }

    array_multisort($vals, SORT_DESC, $keys, SORT_ASC, $res);
}

// mode 'update'
function initupdate(){
    global $argv, $fp, $csv;
    // $filename = str_replace('.csv', '_new.csv', $argv[2]);
    $filename = 'Zlombol18-'.(count($csv)-5).'.csv';
    $fp = fopen($filename, 'w');
    if ($fp == null)
        die("Can't write to $filename\n");
    
    addupdate(0, $csv[0]);
}

function addupdate($i, $row) {
    global $fp;
    foreach ($row as $i => $v){
        if ($i == 0) fputs($fp, $v);
        else if ($i < 2) fputs($fp, ';'.$v);
        else fputs($fp, ';"'.str_replace("\"", "\"\"", $v).'"');
    }
    fputs($fp, "\n");
}

function displayupdate($arg){
    global $fp, $csv;
    fputs($fp, "\n");

    for ($len = count($csv), $i = $len - 3; $i < $len; $i++){
        $line = @implode(';', $csv[$i])."\n";
        fputs($fp, $line);
        echo($line);
    }

    fclose($fp);
}

// mode 'novehicle'
function initnovehicle(){}{
    global $nv;
    $nv = 0;
}

function addnovehicle($i, $row){
    global $nv;

    list($lp, $id, $team, $vehicle) = $row;
    if (strlen($vehicle) < 2){
        echo("#$id ($team)\n");
        $nv++;
    }

    return false;
}

function displaynovehicle(){
    global $nv;

    echo("count: $nv\n");
}

/* current hashes */
$hashes = array();
 
/* #TEAMS autoupdate */
$teams = array(
     199 => array('hash' => 'c80bd2bf808360be108f6f5d539cc63091b1b3fb', 7 => 'Mazowieckie / Zachodniopomorskie'), // 44kuce
     204 => array('hash' => 'c56638a12336bdfc5bbd79bf56cc74bbff7b1277', 3 => 'FSO Polonez 1.5'), // MATADORY RallyGo.eu/team/MATADORY
     230 => array('hash' => '0184758e3fb3e63247421a1c0fcaab83aef844f9', 7 => 'Małopolskie'), // Ładacznicy
     265 => array('hash' => 'e428080fb245c5dce4c27e5d1c1e43831ceeea5e', 3 => 'Lada 2104', 9 => 'Polska'), // Red Neck Racing
     276 => array('hash' => '1d488b833c92d8ce46a471c8c7fd5bdd12e482c9', 9 => 'Polska'), // Ojtam Ojtam
     333 => array('hash' => 'd8ab6c1b502107a08a75c2855d0dc008cbd60b43', 3 => 'FSO Fiat 125p', 9 => 'Polska'), // PRUDENTER TEAM
     608 => array('hash' => '314699cc1d70fcf22c633854e4f3acaf475a75a5', 4 => '2014, 2015, 2016'),
     614 => array('hash' => 'da0e74d658b14747101499f80e90a876e3560d39', 9 => 'Polska'), // dEfekt Motyla
     747 => array('hash' => '36ac48026f1b8d823b55c5920e1a385e4dd59f8f', 7 => 'Dolnośląskie', 9 => 'Polska'), // Dzik
     791 => array('hash' => '00ea7f591c4d730b8b69c8f29deecc370342fc66', 7 => 'Opolskie / Dolnośląskie', 9 => 'Polska'),
     857 => array('hash' => '903e30b988469af1f3fea1de3f0e62a3267deda6', 7 => 'Świętokrzyskie'), // Polskie Zoo
     866 => array('hash' => '7124c2cc3693c27a005e0161bd2347b19c7eef68', 9 => 'Polska'), // Roman i Rysiek
     875 => array('hash' => '5d92d543a61ec85b9a3d05f6c4d9beb0e4397a09', 3 => 'Fiat 125p'), // ArgusTeam (fb.com/ArgusTeam, 2014 Polonez Kombi "Łajba")
//     885 => array('hash' => '4738f47fe3aeefac6f9d3d076e665508c320c404', 3 => 'Skoda Forman'), // skodniki
     915 => array('hash' => '4aaebef7d809883177ef3acf46404231180cf1b5'), // Limbowa xD
     944 => array('hash' => '908da13c07aef6001b7d857cda5e04eac8bfe96f', 3 => 'Fiat 125p'), // PociskTeam (www.pociskteam.pl)
    1112 => array('hash' => '2c83d0e9bb825a4f09fb2e41f43b36db41adbbdb'), // chopy z borewicza (wcześniej Polonez Borewicz)
    1121 => array('hash' => 'eedd3fe092638a50abb88042aacd72a3bae5fc92', 9 => 'PL/CH'), // maupole
    1143 => array('hash' => 'ed82c0c49a592df358c8bc46194b3af10ea35df4', 7 => 'Śląskie'), // medaliki
    1162 => array('hash' => '9ab30a3c3aec9142abb46b98dfb96915f3a29db1'), // Polderrari aka Pinky i Mózg aka Aleksandria
    1173 => array('hash' => '67aa02150c55123593278882813adc42e389a9f3', 7 => 'Śląskie', 9 => 'Polska'), // K-shell
    1214 => array('hash' => '8f4dd6310cf4df3e70d5f69cdba4db3a77b3c5aa', 3 => 'Polonez Caro 1.4'), // 125p kombi kupił Sikor :)
    1241 => array('hash' => '6135269df60b30598537febbb89773d1974f0d4a'), // BartCom Team (wcześniej Fiat 125p (90KM))
    1259 => array('hash' => 'a03c53247558acaf9d08656b60048a48c35fbace', 3 => 'Polonez Caro 1.9 GLD MadMax'), // Protokół Zniszczenia, profil ZlomekGo
    1582 => array('hash' => '31fb9dc4dd9422769dc9299585956be3c2875158', 3 => 'Polonez Truck'), // mkzibi wcześniej Honker 2006 i Polonez Caro i Żuk
    1667 => array('hash' => 'dda3b7b5f534f3a6945066deb2b653c2df43f305', 3 => 'Polonez Borewicz'), // BOREWICZ TEAM
//    1710 => array('hash' => '55dca52f1bd9868830c6eb52daa20f9319c77cea', 3 => 'Lublin2'), // jaspoko | wcześniej Tavria
//    1753 => array('hash' => '0f042ff54d03be15585a20f011f8b1dc2c570b11', 3 => 'Skoda Favorit', 9 => 'Polska'), // SWD TEAM
    1763 => array('hash' => '815f5b9f684cd411f7250c6a55ca7476c86470a9', 9 => 'Polska'), // Ala montana
    1792 => array('hash' => 'fc5b965adb4d420fc37db51073fe0fd02f56429c', 9 => 'Polska'), // white truck
    1831 => array('hash' => 'de8f4d1343bdb3e6fb7664827146e9c7de23321f', 7 => 'Dolnośląskie'), // Super Trakus
//    1865 => array('hash' => '790a5f74cabf1c206e4703bc9650be8c24b48d42', 3 => 'Żuk A06', 7 => 'Małopolskie'), // TurboSierściuchy
    1930 => array('hash' => '7beaa732488bca8f94e65ecdb6e1256a280b42f9', 3 => 'Żuk' /* 3 => 'Polonez Caro 97r' */), // Krzyżacy Brodnica
    1955 => array('hash' => '838598e7db9aba90a43dc7b307c8002ed12243b2', 9 => 'Irlandia'), // boys in green team
    1958 => array('hash' => 'c965d789e91b0784614d7a65ff74ef90339585d7', 7 => 'Vejle Amt', 9 => 'Dania'), // sFORMANowani
    1972 => array('hash' => '9903401ed90434bf98486455464baa7a91f2e842', 3 => 'Polonez Caro Plus 1998r'), // 4x4 Wyspa Wolin, forum: polonezy lista 
    1983 => array('hash' => 'ff7ce17c5350af80e4e1ca8fa18accfb04e8be41', 9 => 'Polska'), // Kurs Kolizyjny
    2015 => array('hash' => '4aa16597b1cf3c39cfaf75a46eb7acb9882fdd09', 7 => 'Małopolskie', 9 => 'Polska'), // Łosie_w_Kosmosie
    2038 => array('hash' => 'ef8316bf652346b41690afc3dd104bd5274facea', 3 => 'Polonez Caro+'), // KanciastoPoldy (fb.com/KanciastoPoldy/)
    2042 => array('hash' => '30dc4a579e5182b5b7aee6b21f4475b755771733', 3 => 'Polonez Caro 1.9D 97r'), // Trudno_Co_Robić?
//    2047 => array('hash' => '2c8ee96d2bfcdea23bb404d92951f0bc95ccf400', 3 => 'Polonez cargo'), // DRUŻYNA BIAŁEJ PERŁY (wcześniej Polonez Atu Plus fb.com/Biała-Perła-Złombol-1541506379467031)
//    2080 => array('hash' => '2c2034ebafdfe089e9e17cf3677c3e0201e79dd1'), // Gwiezdny Patol (wcześniej Auto Zastępcze)
    2103 => array('hash' => '7d1ed7b7ca18d3a71c3da016746d3a443480ef21', 3 => 'Żuk'), // Prezesi Team (fb.com/NoNameTeamZlombol/ 2014 Polonez Caro Plus Klima)
//    2111 => array('hash' => '4db1323c943271c68008ab48725fbc1cec891575', 3 => 'FSO Fiat 125P'), // Wirtualni
    2186 => array('hash' => '6f51f6c89e87e2bd7a17477ebe248d88bdc12de1', 3 => 'Polonez Caro 1.9GLD'), // GAUGAN TEAM
//    2245 => array('hash' => '0becd67990671ec4a683234046e610fe6ef7c552', 3 => 'Polonez Atu 1.6 GSI'), // SREBRNA STRZAŁA | 2017: Polonez Caro Plus 1.6 GSI
    2296 => array('hash' => '68191c777bf8cee85d37253104240551159f1505', 9 => 'Polska'), // Fiqu Miqu Sqad
    2314 => array('hash' => '49f767ca164f6b85de293a1d8d7b1230cbc8f793', 7 => 'Mazowieckie/Aarhus', 9 => 'PL/DK'), // zaZUKowani
    2379 => array('hash' => '0afb07b9313d8e7cdf7331b5b30328c6bf14498a', 3 => 'Polonez'), // NoLimit Odjechane.eu
    2416 => array('hash' => 'c78ecb9409bccb245254046a9a317d4a17557cb4', 7 => 'Podkarpackie'), // OLD BEETLE
    2478 => array('hash' => 'b4be4c4094575ff82bf21a6667cc407270927c9f', 3 => 'Polonez Cargo 1.6 GLI'), // Ściepany Poldon, profil ZłomekGo
    2510 => array('hash' => '5dc1bc9cde9f78cbc4b5ce107b6718c52e73fd04', 3 => 'Polonez Caro Plus 1.6 GSI'), // POMYLONEZ
    2531 => array('hash' => 'f28e14ef6e09c218537e6e82c570dc89dcfc29f9', 3 => 'Lublin II'), // OSK OLAF
    2568 => array('hash' => '536237196f8e04d465a77cfdcd91f231beaa598f', 3 => 'Polonez Caro 1.6 LPG'), // DZIKIE CIAPY)
    2590 => array('hash' => 'e8be9cd3a8bffe7c2ac732e783f4ad5d2b9c7044', 3 => 'Polonez Caro'), // Team Parodia (aka Team Wlodawa), miniaturka na forum (fb.com/ZlombolWlodawa)
    2731 => array('hash' => '4fe2595e4c3dba39a716bcbb8480f920645c2659', 7 => 'Dolnośląskie', 9 => 'Polska'),// oktaKoń
    2733 => array('hash' => '02ef7b64d6c7b29a48347ec504b18bf6650b20e2', 7 => 'Lubelskie', 9 => 'Polska'), // BAŁAGAN
    2773 => array('hash' => '8aa07be58807f4fb3c51567173b5064787d7d33a', 7 => 'Mazowieckie', 9 => 'Polska'), // Core Adventure Team
    2784 => array('hash' => 'b4574a1353dc6e40648914df8e52c7abf24e8ebf', 3 => 'Polonez Cargo 1.6', 7 => 'Dolnośląskie'), // GIT_MAJONEZ
    2801 => array('hash' => '0768aba47e7b82812a4a82ad8cf19ad60e778729'), // Gwiazda Autostrady
    2806 => array('hash' => 'cb5c5091306d1d0195b30405b6015732da839801', 3 => 'Polonez Caro 1,5 GLI'), // Dream Team
    2809 => array('hash' => '3fdd9c6644c6f826ae5d83a298b06a8c7f71a24d', 3 => 'Polonez Caro', 7 => 'Śląskie'), // Czerwony szerszen (fb.com/czerwonyszerszen)
    2845 => array('hash' => '7c5966ce9baf418e884b4d676e9c38e0dd0039f3', 9 => 'Polska'), // TRABANT 601
    2854 => array('hash' => 'e9ed449af6d6171eb31a3933f4c856b400a637b7', 9 => 'Polska'), // Zwierzyniec
    2867 => array('hash' => '91a2546a8aeb0dc36470e699955a419fe8a2092a'),
    2875 => array('hash' => '1a84285217ed07e799cd94fba3650ddcbb81db2e', 9 => 'Polska'), // One Way Ticket
    2912 => array('hash' => '750d2f6493426efb444074437609362b201a25bd', 3 => 'Żuk (Żółty silnik Sprinter)'), // 9 => 'Polska'
    2972 => array('hash' => '2b4b940ad7002db61bb3673b5a2bca9b5705e819', 6 => 'Warszawa?', 7 => 'Mazowieckie', 9 => 'Polska'), // no regions
    2983 => array('hash' => '1dcea024745bf0f94a976fa955baae5eef03b04c', 3 => 'Polonez Caro'), // ZłombolTeamPlońsk (fb.com/zlombolplonsk/)
    3007 => array('hash' => 'd5fbfd0aa19ad6d2ef2eeec73190644449d9f307', 3 => 'Fiat 125p'), // Bondziorno team
    3057 => array('hash' => 'a16332a39670d6e4fe92a58abd87a7fce5836b72', 3 => 'Polonez Caro Plus 1.6 GSI'),
    3060 => array('hash' => '1e0d2c42242f9010e191e0fb0d045567db1cc8d8', 9 => 'Polska'), // forum: Lublin II
    3072 => array('hash' => '04eab671a48599b344f67e2eac8c60720552cb13', 7 => 'Lubelskie', 9 => 'Polska'), // ŁADAmoment
    3093 => array('hash' => 'd4aed67a413355a071fedfbcdf44d9dd824ce643', 7 => 'Lubelskie'), // Lublelskie
    3106 => array('hash' => '9c6985ec960d80b6fe3db637a91af3cf8cafb806', 3 => 'Polonez Caro 1.9GLD 1994'), // 07 zgłoś się
    3132 => array('hash' => '7e754ae126d4b810411723663810dc17c46f6651', 3 => 'Żuk', 9 => 'Polska'), // forum
    3143 => array('hash' => '6138fb89995d81b06929e0a946d5ebfcaa142d70', 3 => 'Żuk A 07 4C90'), // JUKE Team
    3151 => array('hash' => '500c41bbb65ea9f9fe7b5b76c7272b82998061bf', 3 => 'Polonez Caro'), // Motyla Noga, miniaturka na forum
    3160 => array('hash' => '54aa72f8407d392b2895f99e6bfa490985e738cc'),
    3162 => array('hash' => 'e29e7c4d2af03a9244914c258b5d68b474084e72', 3 => 'Polonez Borewicz'),
    3168 => array('hash' => '9e1be4c47f4868cdfd79b93ad7696efed59be492'), // Tomahawk-Szerszeń
    3178 => array('hash' => '68847074d8c5782c5e220514335f5a20fcec62dd', 3 => 'Polonez Caro'), // PolLub, miniaturka na forum
//    3203 => array('hash' => '8c567daf0c76acfd7da8dcb06d8938b9543d4ea8'), // OK! "Byle do przodu Team"
    3209 => array('hash' => '6af80db5b47c463ed3cafd5d237bfcbbdd0d6a7a', 3 => 'Dacia 1310 kombi'), // forum
    3213 => array('hash' => '1c0dc8c4131df3ef9063bde326d7a65417f60682', 9 => 'Polska'), // ale o fso poldzi?
    3217 => array('hash' => '39c80ff702194a0be9c61b28876791e8141a1327', 3 => 'Polonez Truck Roy'),
    3220 => array('hash' => '7e9b801b88ac18c46c6074deead98ea75ddd5270', 9 => 'Polska'), // ŻULIKI
    3234 => array('hash' => 'f1ca8941a4e801903f2da8819d63895117deffd9', 3 => 'polonez Caro 1.6 GSI'), // Czerwony Byk Racing, awarie na ZlomekGo.pl/team/1242
    3273 => array('hash' => '6cca66e381e8dcb44ffad0f4bbdc28ed5609ca28', 3 => 'Skoda'), // Škoda nie jechać
    3313 => array('hash' => '2ff9e20435f7222ff987b21a2a023332c89780fa'),
//    3315 => array('hash' => 'ba2c7dbb5aae3c0e74ee5745cc2c8187000137aa'), // OK! BardzoNigdy!
    3320 => array('hash' => '45e649ca580d60646d5bcf4911236e7d97bfcc09', 3 => 'Polonez Caro 1.9D'), // POLDOSTRZAŁA
    3329 => array('hash' => '0924130faaa7462afd5d202f06be3eddee4970d4', 3 => 'Żuk Strażak', 9 => 'Polska'), // Kurczak Truck | wcześniej polonez Truck Roy
    3366 => array('hash' => 'b6d5e498a87cad8550264a808e8ccce966b3bcb6', 3 => 'Polonez Caro 1.6 GLI'), // WLKP, awarie na ZlomekGo.pl/team/1383 (3inżynierów i blondyn)
    3374 => array('hash' => '9ec7957673e7b17ebce67da6e4f5d68de571c19d', 3 => 'Skoda Forman'), // Twarde Grochy ? Łada 2106
//    3402 => array('hash' => 'd23702b0fb35c7c552a9877c971cb84bc25d61b6'), // OK! "DEJ-MUUU"
    3503 => array('hash' => '190ffc88e87ef8c28d4c44c0c525b768729314d0', 3 => 'Polonez Truck'), // Nie dojechali (fb.com/Zlombol.Raclawowka)
    3513 => array('hash' => '75207d6fe7288b8da514dd150c32eec3fc9853f7', 7 => 'kujawsko-pomorskie'), // PAŁUKI TEAM!
//    3526 => array('hash' => '447e4d673cd47eb584540f48fa06096b217d00d3', 3 => 'Łada 2107'), // OK! SpodLady
    3550 => array('hash' => 'e269e13a1d16cd8608122a8620fdf2caf88a0e2e'), // ŻUKiem
    3596 => array('hash' => '008f7ecdd5975ffb8b0dcd7b87be0f5e6cc33c8a', 7 => 'Dolnośląskie'), // Dzikie Żółwie z Mordoru
    3795 => array('hash' => 'd0d02469718de5857800b7d3efcf710a45c567c0', 9 => 'Polska'), // DARMAN NYSA
    3871 => array('hash' => '8af11cffd9aaa9fc4218f547eb767779b8a12705', 3 => 'Polonez 1500 AA'),
    3983 => array('hash' => '452cad8819b48776d1b83c3ae15ae70fc6b782a4', 7 => 'Dolnośląskie'), // OrkizMajorki
    3985 => array('hash' => 'c1c364aca86b6074c776d8c0e8c35a0d73909824', 9 => 'Polska'),
    4052 => array('hash' => 'f8d7c256257dab85418e218c23fa79da08d8bb8c', 3 => 'Polonez Kombi LPG'), // Królowie Pobocza (fb.com/KrolowiePobocza)
    4088 => array('hash' => '1b486b6cc9deaef11bb8be844ca44c3450006c8a', 3 => 'Wołga', 7 => 'kujawsko-pomorskie'), // Bydgoszcz Brothers RallyGo.eu/team/5b5b06ec1784152e8d7b7b3a
//    4122 => array('hash' => '5569d4b537deb1640ffd3e17eddd12b135746d78', 3 => 'Skoda 105'), // OK! Światowid
//    4143 => array('hash' => '5ae603cae84215592c55348dae277f3f1f0a239f', 3 => 'MZ ETZ 150'), // OK! SanchoPansa
    4160 => array('hash' => '0375ad9b04796d79bff6f0f9720e0848458316a3'),
    4194 => array('hash' => '916e6429f5a77dc1994f6df26da3fdd8e011014f', 3 => 'Polonez Caro Plus 1,6 GSI'), // Poldolnięci, zlombol.pl/forum/zlombol-2016/14105-polonezy-fiaty-lista-z-numerami-tel?start=40
    4198 => array('hash' => '52558701323afbd9b5aec26ed2e00a4264d2158d', 9 => 'Polska'), // TAŃCZĄCE SALAMI
//    4295 => array('hash' => '0588794a4bbe6848b01269cf507e3942318649cc'), // OK! Zerwani ze smyczy
    4296 => array('hash' => '0ece03cf8bf02e8a110e53aca7d68198a431015a'),
//    4311 => array('hash' => 'd63e76c09869d8205041692209e05eec9f801b12', 3 => 'Fiat 125p'), // OK! szaj-bus
    4325 => array('hash' => 'fa5182d9619a681e5c95bd038600aad34b30acbe'),
    4339 => array('hash' => '7d8bd48a2cb1c680d63a0bf0dd0920a39e38b271'), // MALI I WŚCIEKLI
    4342 => array('hash' => '3e21286a1abca37ab686b7058639d915de979dcb', 3 => 'Polonez Caro'), // MIELEC POLDOPOWER (fb)
    4362 => array('hash' => '5039d8afb9e8a0b6550bbac16b32290add013d59', 3 => 'Nysa'), // zdjęcie profilowe, SIENNA
    4371 => array('hash' => 'af06880ecfedd75821bcd3a87a75dd8a9e381343', 3 => 'Polonez Akwarium'), // AndrzejWeźDwie, (fb.com/andrzejwezdwie/)
    4396 => array('hash' => '8bd8973339d54cd88f040210947fa59a6961fde6', 7 => 'Łódzkie'), // Palmer Boyz
    4410 => array('hash' => 'cc61fe3474292515c6728a987abdd264bc6a03af', 3 => 'Skoda', 7 => 'Śląskie'), // po nazwie pojazdu: Skodozord
    4413 => array('hash' => 'a48705e94278ba6518653e7b50c0d1fe2fe9ac06', 7 => 'Dolnośląskie, Lubuskie, Wielkopolskie'), // Maszyna Do Pędzenia
    4425 => array('hash' => 'ae3c1ce3abb018a813a0607652518873f95cd061'), // Motór
    4443 => array('hash' => 'c14eee849917dfccab985660508442fc756ef395', 3 => 'Polonez Caro 1.6'), // profil Smok Expedition (2014), http://www.nowaostroleka.pl/wiadomosci/16633,zalogi-z-ostroleki-na-zlombolu-zdjecia-z-trasy-video 
//    4530 => array('hash' => 'd02a225867c44b8e7b17b088e21d26245000b97b'), // ObieżyśFiat
    4532 => array('hash' => '28a9d32480e790432f77acb0c673d8eae19815be'), // Sokół_Milenium_1
//    4536 => array('hash' => '1d5df28b56f66da3b3547607714f03a3b6d0b799'), // Tabaka Team
    4547 => array('hash' => 'cf4437b0fc6b2b0a514fa059adaf7f2ade17cf20', 3 => 'Polonez Caro'), // youtube, Kolno Team
    4570 => array('hash' => '1da5131c32dc68dede6561725f6d94c04ba8f32e'),
    4574 => array('hash' => '1eed6a4775b57c0af039cc570c42f172f0bafda2', 3 => 'Polonez Kombi GSI + przyczepa'), // Prezesi, zlombol.pl/forum/zlombol-2016/14105-polonezy-fiaty-lista-z-numerami-tel?start=70#41447
    4575 => array('hash' => '1264dba2fe34b670262f9d0cca0b0d7cd8896a45', 3 => 'Fiat 125p \'81 1.4 Rover'), // Cali na biało (fb.com/ZlombolCaliNaBialo)
    4581 => array('hash' => 'b5ff7967189bf43e634460b300be0aec26b69180', 7 => 'Mazowieckie', 9 => 'Polska'), // Wartburgerowie
    4586 => array('hash' => 'c75faa527d424d49c018ad7a4a3773fb8b928485'), // Żuk Blaszak Team
//    4588 => array('hash' => '97a7b7434e5e44ae4423636be3ddc6b1332cd171'), // Czekając na lawetę 2 - uzupełniona lokalizacja
    4589 => array('hash' => '6d1cebd09c00072296dc1c4117f846fb005a33f3', 3 => 'Żuk'), // RZÓKI, po nazwie pojazdu: RZÓG
    4597 => array('hash' => 'd2afa8764b42f2e8de9918751da24c6b90487402', 3 => 'Żuk'), // po nazwie: GimboŻuk
    4599 => array('hash' => '44cb2bc2c5e61d1968f9436191df6f07af53ed1f'), // Cwaniaki z PKSu
    4613 => array('hash' => 'e704a873f2d98375287dc5c63e2fb75edf103acb', 3 => 'Polonez Caro Plus', 7 => 'Wielkopolskie'), // Rancho Colorado, (fb.com/rancho.colorado/)
    4619 => array('hash' => 'e42647c13c1f51dca4bc285ee3c093355e7051d7', 3 => 'Polonez Karetka'), // Janusze Złombolu
    4621 => array('hash' => '0aa7b7b903037edf54c40ca3a34d26ae6244f4e6', 3 => 'Polonez Caro GLE'), // Pierońskie Hanysy, profil ZlomekGo.pl/team/1431
    4662 => array('hash' => '555f2d18c50745081cbdab1eecfd84959c6038c6'), // #NTPBJNG
    4681 => array('hash' => 'b989d120927f66696e1307725dcbda8159de7d45', 3 => 'FSO Polonez Akwarium SLE'), // Auto-Części Markuszów (fb.com/autoczescimarkuszow/, akwarium)
    4966 => array('hash' => '7eedb09357eb2d129cc27b6a939e6b74e06cfca4'), // Team Nowaki
    6454 => array('hash' => 'f49851e7b5c420b48d46af60c0fbdc9a157b7765'), // se#da!qejsza8hmp@
    6473 => array('hash' => '10dca4770e8182b8debcf652736b225a4c849a4a', 3 => 'Żuk'), // Happy_Patology_Team
    6498 => array('hash' => 'c46a4172b12ff29a17a8c17a7544af555954b3ba', 9 => 'Polska'), // Jogurciki
//    6506 => array('hash' => 'b3a5b5b11302dad7224761f787874ce333e97492', 3 => 'Skoda 120'), // skoda suchego
    6540 => array('hash' => '64ff8213c1725ee974da68034135ea37d0fa1527'), // Reakcja Łańcuchowa
    6557 => array('hash' => 'b77a3f7f9836e7d05a4904bb088960bb6f2f770c', 3 => 'Daewoo Lublin II'), // plan-A; po nazwie pojazdu: Daewoo lublin
//    6562 => array('hash' => 'fe3efbd4413f16398b4ad455e0206d499d2b0ce3', 3 => 'Lublin'), // Seledynowy_Skrzat; 2017 Skoda Favorit
    6563 => array('hash' => '355269405988d30ac3db6d852f790096eb23f987', 3 => 'Skoda 105L'), // MECHANICA TEAM; po nazwie pojazdu: Skodillac 105L
    6566 => array('hash' => 'd94ff5622e19b332ef28bbf73b321b54981ca3c7', 7 => 'Dolnośląskie'), // RacingTiresFunTeam
    6572 => array('hash' => '60999612a7b57d72e5e1d585611e2926776fd95f', 9 => 'Polska'), // PORSCHONEZ TEAM
    6582 => array('hash' => '3e6cdddd4d756833e46c47c1b63b58fecaa885d9', 3 => 'Maluch'), // MalczanemPrzezŚwiat; po nazwie załogi
    6696 => array('hash' => '92fc9c3a1606643b428000395ccb5a8a3965dde0', 7 => 'Slovakia', 9 => 'Słowacja'), // HIIOX TEAM -> 'Bratislava' '-', 'Slovakia'
    6700 => array('hash' => '7ce65bcf1ffa44bfdb82d9f6e901bdac26fe87db', 6 => 'Opole', 7 => 'Opolskie', 9 => 'Polska'), // BOLID, lokalizacja info z forum
    6704 => array('hash' => 'ba9990ab6cbd5c0edeaf3d1bb78c31d019f45e9e', 3 => 'Polonez Caro Plus'), // OWSR; po nazwie pojazdu: Poldolot+
    6713 => array('hash' => '617b25f332291829bc04a929ebd488b0e002d679', 6 => 'Warszawa', 7 => 'Mazowieckie', 9 => 'Polska'), // Morsy Sahary
    6737 => array('hash' => 'b5c5db874e45abf66a914b285c3ff09cd049dac8'), // Minttu Warriors
    6758 => array('hash' => '5824639810811b62ce9387a119587c1c15cdb5ae'), // MG Transport
    6828 => array('hash' => '4dead3cfb8a71dd42ad4de19e60917c7a6de9992'), // Szczerbatki
    6871 => array('hash' => '9b268c7870ce73171f678672bfd10c87a015d035'), // Ladidos
    6877 => array('hash' => 'db4eccb509f002310b377ea80d335c25aa7e4b0d', 9 => 'Wielka Brytania'), // SammamSampcham
    6902 => array('hash' => 'a900627b49eed565e1863519c5ee635575bb31c7'), // kanio1
    6948 => array('hash' => '08477baaeb29c7fe5b6198cc0b3887e575451a29', 9 => 'Polska'), // Tourist
//    6939 => array('hash' => 'ab44a2f48273639cf9348b5c9a1fc7b1e5ef3f26', 3 => 'Polonez'), // 2brothers
    6959 => array('hash' => '1b2449f88de370a4c3d76c551c6ab3458f1d2230', 3 => '-', 9 => 'Polska'), // WŚCIEKŁE WIEPRZE
    7006 => array('hash' => '638d98990cd87fecf6a82fc0f874ea96ee720a29', 7 => 'Dolnośląskie'), // Hoppy Moto
    7035 => array('hash' => '3e8840d27aeb6c9126328519c1c8bad7b08aa635'), // Szkoda
    7051 => array('hash' => 'b8636532fdc33ee00f65c09ac0485b066f7adeff'), // ReMobil-500
    7134 => array('hash' => 'a68d928f4f8ee343754940b0f165fafa94a79ef9'), // furmankąprzezświat
    7199 => array('hash' => '57b5e99f865cc78823f2862e7dcd49d46f022aa3', 3 => 'Polonez Caro 1.8 Rover'), // Mielecpoldover
    7228 => array('hash' => '6026bf4194184f3c57040998291c24a4b5be2443', 7 => 'Zachodniopomorskie'), // Skodolot
    7252 => array('hash' => '256943517dfb9453953843f79526f292284fee5d', 3 => 'Polonez Caro LPG'), // MielecTeam
    7269 => array('hash' => '013916336d2858a9d544bfe94617a8db1c65e89b'),
    7293 => array('hash' => 'd542489c49eafcaaff5c3ee347acccda1617b9ed', 6 => 'Swarzędz', 7 => 'Wielkopolskie', 9 => 'Polska'), // Zerwani_ze_smyczy RallyGo.eu/team/5b5b06ec1784152e8d7b7b3e
    7298 => array('hash' => '335e809660195e8849ba18f6bfbfe8a13789ebb1'),
    7306 => array('hash' => 'de7c657e5bf4f889ce2b4600d8d8d8d3305e2076', 7 => 'Małopolskie', 9 => 'Polska'), // Biała Mewa
    7338 => array('hash' => '8b0dcf4e3b45a7302099aab8017c177d349007c4'),
    7351 => array('hash' => 'f49bd4d2723ef2d2cc3be151b8411c9a601cf91d', 7 => 'Dolnośląskie'), // BARTON TEAM
    7358 => array('hash' => '803628de3a881260830024d3341a5f1489dcf5d2', 9 => 'Polska'), // ChłopcyzPlacuBroni
    7362 => array('hash' => 'd02512ead66c92476cb9030d1c50b102f838cd4f'),
    7366 => array('hash' => '70a2ac10477e90346cb342923b67a53b8d2f6a2e'),
    7369 => array('hash' => '898ea78689c79d10da85edbf4e1931afe8ab160a'),
    7371 => array('hash' => '1e6b27a185ec6d2c25d90369d7c2da309b72192b', 7 => 'Wielkopolskie', 9 => 'Polska'), // KAPUCZINA
    7373 => array('hash' => 'eacdf0f6ee9047eaa10d4dfcf5a7eeef8e1e7c02'),
    7374 => array('hash' => '6dbe8aeea1ae97316b54a4566382f837caf1beda'), // LUX_KOPYTO
    7375 => array('hash' => 'ac54aace71aec11320379ec0c8bda215558f95fb'),
    7381 => array('hash' => 'b97f1ada1c7c292a2ffd17746aec67a8bd2ef62e'),
    7382 => array('hash' => 'f2f4db7b944c5aa9532e337e19ef5e0bc668d296'),
    7385 => array('hash' => '156ce19e53a5d29727dd5da78030e88cbf5811e6'),
    7387 => array('hash' => 'b8fc0de604e12db47b3cf3ce7be902f517da757e'),
    7398 => array('hash' => '687fa056aeda39ca1d798aff5275c87ec88cf888', 9 => 'Polska'), // LizawkaHRPC
    7541 => array('hash' => '4a6118d25f440e419f5d09b02244d8175d95d6ba', 4 => '-', 6 => '-', 7 => '-', 9 => '-'), // !!!Złombol_official!!!
    7713 => array('hash' => '09614a071446ea26135af95de5470337a9628720', 7 => 'Dolnośląskie'), // 71ferajna
    7872 => array('hash' => '02943364693e4cba9b5f7e1a509cc29c51124f36'), // LKR
//    7902 => array('hash' => '921aa58df25e105b922e92117cccc5d354fb2258', 3 => 'Fiat 126p'), // Chrupkiem Przez Świat
    7904 => array('hash' => '0449b29e33ac5dac1c0eb4d074921d0aeda32d19', 7 => 'Dolnośląskie', 9 => 'Polska'), // TourDeTrabant
    7937 => array('hash' => 'daac414806f197352ac92a6595e1034985a41ce2', 3 => 'Skoda Favorit'), // Go-Fun
    7947 => array('hash' => '3f05bbf84ff70d559b57afcf8ec4a48257736b91', 7 => 'Mazowieckie/Lubelskie'), // OBRT
    7984 => array('hash' => '4abca816ab959c663d23ad380448b731f8bce703'), // Domkiwsercukaszub team
    8012 => array('hash' => 'e6a926f4f05dab4b5999ca8ce93c065d44aa0dee', 3 => 'Polonez Caro 1.6 GLE'), // Jager team
    8016 => array('hash' => 'c8d57897a866fe9777b6987a0c92222725a19bf9', 9 => 'Polska'), // Z fartem
    8019 => array('hash' => 'd94a4d26e3df913e6df95e86caefb7b7b709fe55'), // GRUPAALFA
    8028 => array('hash' => 'e6c24798a9d575a715ccc9a31d082eaf0f896e44'), // BES-Lase-BOX
    8182 => array('hash' => '65702e9ede94bef27731a148cab0f6401e539396', 9 => 'Polska'), // pieknaibestie
    8183 => array('hash' => '9eff296d20bb20ecb1e8ca1cc6c25ef210674f6d', 6 => 'Warszawa', 7 => 'Mazowieckie', 9 => 'Polska'), // JaziCatTeam RallyGo.eu/team/5b203953291c7f595adace61
    8234 => array('hash' => '928bf44eb6e8d1cb6abf1a1c5840dd77df734576'), // BATORY TEAM
    8250 => array('hash' => '50481f45349c4b4e8514ab7d15fcbe069e0a8249', 7 => 'śląskie'), // SpaceToaster
    8355 => array('hash' => 'e88a0c3c6f1582f37f7bdd4db2eecc83b43b6bb7'), // stalowy coco
    8402 => array('hash' => '4e89da07708d563d684a5d56a4e6851cc170a724'), // procon_tim
    8404 => array('hash' => '04b8e0ed0db8139d566bd94cfc91f258848b8061', 7 => 'Lubuskie', 9 => 'Polska'), // dobroszowspeed
    8442 => array('hash' => '5303184756e74587b2e69f2f1de363dc8cdfbb49', 7 => 'Świętokrzyskie'), // BezPrzeglądu
    8488 => array('hash' => 'a3524a907c2319e0e0ccc926a9e1845052622964', 3 => '-'), // MAVERICK
    8485 => array('hash' => '443596693f3f0a7d5aed703b30c72525799a0e71'), // Drużyna AAA
    8507 => array('hash' => '51d51886013e92065b48d33a2899099eeac69c03'), // Szwagrywżukatti
    8662 => array('hash' => 'e1c52e7d256715019b1c44f274a616195b9f2b27', 3 => 'Polonez Karawan 1.6 bosch'), // fsosport RallyGo.eu/team/5b203953291c7f595adace91
    8710 => array('hash' => 'c06e3e17a1e266cf7be7b2886274ced817f0ac61'), // RycząceCzterdziestki+
    8750 => array('hash' => 'd3875632f316cf32f7332b8e97640ba9acb6a1df'), // Polokard
    8775 => array('hash' => '3785bafa1abe0ae8f1cbf5117f637796f42ff27f', 9 => 'Polska'), // Zielona Crew
    8812 => array('hash' => '553eaeb430101bebaf463a420cbcabeb6f914f4e', 7 => 'Opolskie'), // KaRaMbOL
    8950 => array('hash' => 'a38f7d2007b542c57efe95855b01b432ff32ea0f', 7 => 'Śląskie'), // CZESKA MYŚLIWIECKA
    9056 => array('hash' => '3ec4fd9aa3211fe5550cda44b9c4de86c90320aa', 7 => 'małopolskie', 9 => 'PL/DK'), // BAŁKAN TEAM
    9064 => array('hash' => '5e137bf3e7b5970f9cd9b9b26ca0d513da1078e9', 7 => 'Mazowieckie', 9 => 'Polska'), // STRADALE SZFAGIER SQUAD
    9170 => array('hash' => 'fc7b28347436cb305098fa8a0b061aa662cdfa89'), // szosownik
    9251 => array('hash' => 'a668acef8297029328f99647cb1fd38e8db5aea7', 9 => 'Polska'), // GWIEZDNA FLOTA
    9331 => array('hash' => '9e96c91e6d496366673c2154c074aaaef12bc375'), // PARTy
    9357 => array('hash' => 'b887b871a99ace6e8bb9ae5563183a97fb7407c2'), // Pożycze LPG
    9367 => array('hash' => '62bb8d4fd57823bc8b3bfb947a427a967c99d7f8'), // Martell-Adventures
    9374 => array('hash' => 'bbe0cfd9a68ae8b7a873d2b4145f30e8bac5d6c5', 7 => 'Pomorskie'), // project Ƶ RallyGo.eu/team/5b27b184512c8f49ba7a4b7a
    9378 => array('hash' => '2cc57e10a63714e794cc66b6458e67c2ecbd20ed'), // Sławek
    9380 => array('hash' => '2dfbf8ff3025a87f679223753060ea3e8b8b6dc9'), // Wojtteam
    9382 => array('hash' => '78515c22add358aaeb054c8d0b79a84bc6481277'), // W pogoni za Januszem
    9393 => array('hash' => '3f1b6fffabb14654b92c82402b4d833c24718296'), // LatamBoLubie drift team Gorzów
    9399 => array('hash' => '87fe8d697728f6678824ec4bc56eb24caab3a59d', 9 => 'Polska'), // WARTBURG_IFAJNAEKIPA
    9411 => array('hash' => 'eafc1737fd6b5c7fa29d73a3936cdc264761613a', 3 => 'Polonez Karetka'), // FSOtnik
    9444 => array('hash' => 'd8c9faaa5cb3f3403dc3a3483e4664896cd9f521'), // The Polis
    9445 => array('hash' => '5c84a48505575c4592101cb77f262e0ad604a35b', 7 => 'Dolnośląskie'), // Biedroneczka Centurion Team
    9450 => array('hash' => '40589d3f862495ef3459bd9421b599d6f8321945'), // Le_Mila
    9456 => array('hash' => '55f6546e577a3a14d3962b429e1912d501546b9b', 3 => 'Polonez Caro 1.6 GLI', 9 => 'Polska'), // Slunskie Hahary DT
    9480 => array('hash' => 'ea10dd6adc00d210aa857c9e7a00ae202e1d13d4'), // Knurururu
    9485 => array('hash' => '312b61fe79ead9f73e146270a280ee769e27fbc4', 7 => 'Małopolskie'), // ALKO-team
    9519 => array('hash' => 'c2e0f6e5a811c648f06e4ab627fd09bfde56cbcd'), // Karetkoholicy
    9530 => array('hash' => 'cfa2bf0fce3da7cb9c48dda8788ed9da724c8897'), // MS Batory
    9544 => array('hash' => '3ae0c9b9404f31c0faf9f82fe47189141930b883', 7 => 'Kujawsko-pomorskie'), // POLDŻERS TEAM
    9542 => array('hash' => 'cf50d33e589577026de7715402cacd6c16f02f4e'), // Mecholonez
    9555 => array('hash' => 'b13f9092a83534a8075bda66065813c1da1d8416'), // Skibsonowie
    9557 => array('hash' => '8d502f887523222117c6f1cc7d099d101b323824'), // Węgliki
    9558 => array('hash' => '8efba8ccfad2d773ab460e43579b91acfba13ee0'), // ROSART
    9569 => array('hash' => '7aaab3e379db2ea2345eea3498570e3b83959b99'), // Handlarze team
    9575 => array('hash' => '947aeee3b98859908b9dfee87a84a843a67bceae'), // POLO
    9576 => array('hash' => 'd24b06b105c8b2247a052ff88b225b4cc52bdbb1'), // NEZY
    9583 => array('hash' => '9b38e736416865990f06b341dc55b5536d38dec9'), // HORDA328
    9591 => array('hash' => '29b25e0cc66661c3a0d6048522815362f131ccb4'), // WYKOŃCZENIOWCY
    9594 => array('hash' => 'a715ea27c139afbda92ececb30e068c969aa6b6d'), // LastMinuteTeam
    9597 => array('hash' => '86a482f69e54d78718b925d1376110c8ff2b57fa'), // Poszukiwacze zaginionej Warki
    9602 => array('hash' => '25be79dffa7e6a2c93415c49c759414a905e6ca6'), // ŁOWCY POLONEZÓW
    9604 => array('hash' => 'f590474baf156c2b13982ab14bb1ef0af216fdad', 3 => 'Skoda'), // SKODA Z ZAGLEM
    9605 => array('hash' => 'b2b3a34ac6d841ff1ea8868d5ecb3bbe32d8a726', 3 => 'Żuk'), // Legenda o Żuku
    9608 => array('hash' => '3aee3d9b12a9d6e14ae4ad055c7c527a7687fde7', 7 => 'Kujawsko-pomorskie'), // Andreanalina Team
    9609 => array('hash' => '059bfbe7e594cfb6cb73be2c9c2a1097f1f33a4c'), // Młodzi Wilcy Nowy Narybek
    9614 => array('hash' => '3463e86adcc6dcc994719715d3aec0c570664462'), // Kundel
    9618 => array('hash' => 'ab5a43a031cf73a24ea9edc2d512df8b194f22a2'), // ZaSzyc
    9619 => array('hash' => 'c712c3ca013061a3f92f82e55c8b24bd13993ee7', 7 => 'Śląskie'), // M.M.A.A-CARO
    9625 => array('hash' => '8046f6baa6e88f10af5d2cea77db7067e7d8154f', 3 => 'Polonez Atu Plus 1.6 GSI'), // tartak_team RallyGo.eu/team/RallyGo.eu/team/
    9628 => array('hash' => '64e1900ff209c705ee10719130064163c70004bf'), // Kardynał
    9632 => array('hash' => 'afa9cd75ab1b93896d8ffa2dc10fb5db3908abde', 3 => 'Fiat 125p berlina 1500 r 1987'), // Kary
    9636 => array('hash' => 'b532430a45726ac6a773a5c37b1659f0df18c6e0'), // Drużyna Bursztyna
    9638 => array('hash' => 'bb57f84d30279052924748f0e5e85938db133896'), // kotlinaklodzka
    9640 => array('hash' => '628f96ea09b72a5c85b750a73524dd1336b2f868'), // grubeżuczki
    9641 => array('hash' => '1f99418d47f48e67777a218f6220b9f0d1c8529d'), // Poławiacze Pereł
    9643 => array('hash' => '82b74f07edd86b74c6fdd5a4fbeea40f01cc8d64', 3 => 'Łada 2107'), // NiE ŁADA WyCzYn. RallyGo.eu/team/5b61c3ec7e1c861d5a193215
    9648 => array('hash' => 'f8740185d2db8a7f6218492d5aaa643dc3eb5b13'), // GANC TEAM
    9649 => array('hash' => 'b2038ad16474cd3928b0bc0b7e2c2382fe56bdc2'), // Pędzące ślimaki 2018
    9665 => array('hash' => '29684d1a5e16ead2cc73297427e34379973f6f0a'), // UchoRajder
    9777 => array('hash' => '8b3f647998d5becef5a70b001507bec16b6e1d06'), // LCS2018
    10021 => array('hash' => 'd487dad5b4c50f2a159b9cb7cbb78d657bff6891', 7 => 'Śląskie'), // Raccoons Team
    10034 => array('hash' => '6a8101d37bffc610b704aafda28af301c174b2d9', 7 => 'Lubelskie'), // TOnieMY
    10035 => array('hash' => '2f1d676b5ed42f2386413e07746613ad91461dda'), // BezDrożnicy
    10056 => array('hash' => 'be70d8b1bcbb5132a1ef09af7925ecc3fdac3b0d', 7 => 'Pomorskie'), // SPAGHETTI POLONEZE
    10065 => array('hash' => 'c12fc365e0f2271abcb6954f78cf06b3e88fe6dd'), // BEZ CIŚNIENIA
    10077 => array('hash' => '879825059e12a303ed9ead914537d6f94d98bf4c'), // Husaria
    10084 => array('hash' => 'f4749fae92e65a9593fe83dcb4330d84c628da91'), // pawell82
    10087 => array('hash' => 'e74a3e6cf86d9cbf39526670f8411334bb3494f8', 9 => 'Polska'), // Jadymy Durch
    10094 => array('hash' => 'f0f2129481f775588556e089a81da800af1700e4', 7 => 'Łódzkie'), // Twarde Tłoki
    10128 => array('hash' => 'd6d838afb1f8ca5b2d80f0a9ba2e411ade29436f', 7 => 'Mazowieckie'), // TURBANY
    10146 => array('hash' => '4be7be0495dc221f362249574bf964e113951f83', 7 => 'Świętokrzyskie,Mazowieckie,Zachodniopomorskie'), // WPT
    10148 => array('hash' => '2e0a5a80701ceaa1ae77f84df8c925b84e01efcc'), // GniazdoPiratówTeam2
    10149 => array('hash' => '4e7ab53f161485250e46af253669086e7e5b0c7d', 3 => 'Lublin 3 Andoria'), // Lublin2Dublin | formu: zlombol.pl/forum/zlombol-2019/14920-poszukuje-pilota#49706
    10155 => array('hash' => '09b83c945d68a4661cb825ff934269eea3642897', 7 => 'Dolnośląskie'), // MiedźRuda
    10186 => array('hash' => '8080815b66838ba4be9edaa910128c39f15da791'), // czeskifilm
    10205 => array('hash' => '3b4f82a63a39a99548e79864c93db8e89411abc4', 7 => 'Łódzkie'), // sam_olej
    10231 => array('hash' => 'badc7e97ccbbfc60e00e673441398723359c7420'), // Cezary Gajowczyk
    10238 => array('hash' => '5f8c70830f4de6b55cedfe7488c4f96eb0b9f9a4'), // Bonzo_16v
    10255 => array('hash' => '69eab629931c6ab45e0b0f018d722403e577f6d7', 9 => 'Polska'), // Sokół Minionego Milenium
    10259 => array('hash' => '29a63e5132e2a05c252790e74bfae3aa990a2afd'), // Czwarty Grzechotnik
    10265 => array('hash' => '9383289e8364f24efaa7eeee58752171d0de7dff'), // Nuwelasy
    10271 => array('hash' => 'f3e36d71cd0c877af0fda8cc7d38eaff4e25efc4'), // asmteam
    10272 => array('hash' => '5adb1a7ae4b5da65c8848485bf95132a8bd20c7d'), // fsosport1
    10304 => array('hash' => '5ed0d2f8b26c422504a8f31b471345289d1590a6'), // Wściekła Kuna
    10307 => array('hash' => '59cce78aaffd00ed1d41bfa75775b3d0bfb3a701'), // MOTOZŁOM
    10310 => array('hash' => '671515cc6330bb5b06ed430f7db4bcb496041903'), // MWJ LUDWIK
    10320 => array('hash' => 'e52417a9a2027cbeb0aa0e1b577c1d1172c34437'), // Hangar Honker Team
    10321 => array('hash' => 'a188be7432532a776bad0a433fdd6733934d43aa'), // ZerwaniZeSmyczy
    10323 => array('hash' => '144fdb88139942cda5d39c9e08ec2efc4b60ad7e'), // poloKombi
    10326 => array('hash' => '2741ec527968f97b8598617b86a7007d2a401523'), // #poldoboy
    10327 => array('hash' => '83c48b94f786f83bd212228bbbb0f97f30a1cb87'), // cargulec97
    10328 => array('hash' => 'd1a61997fde2dd7775449b34957912dbe2cdd922', 7 => 'Wielkopolskie'), // Mongolscy Przemytnicy Rzeżuchy
    10331 => array('hash' => 'd55e7662987d75c1553ecbfc0dba5e418effde51'), // Lublinem_Na_Złombol
    10332 => array('hash' => '16762d43ab428fd8f7f8965485e476d50e0feaa5'), // Żule3
    10334 => array('hash' => '47b0d690ee2d53f40b0a08a46dffe598885cc4ca'), // DajŚrubokręt
    10340 => array('hash' => '3dc27dc9c97dea80f97f4c023c8457158ffe376b', 7 => 'Dolnośląskie', 9 => 'Polska'), // kpt. Niemoc
    10342 => array('hash' => '8577d3416102645358fca8a53a04781df4c343bb'), // HAKUNNA MATATA VOL.2
    10345 => array('hash' => '16af656c39dbe38dd30e6df712ef40b4c7aabee7'), // SWIMER GIRLZZZ POWER
    10346 => array('hash' => 'adcd450fc65e702d49a13cb726f5920f9a073890'), // Jak Pan Chcesz
    10348 => array('hash' => 'ff6dea63e7e56a0467d60da4fa551abd19984695', 7 => 'Wielkopolskie'), // Dobrowolne Stowarzyszenie Posiadaczy Młynków do Pieprzu
    10350 => array('hash' => '25caa2561e70e8fa12fa3a54ce9af3acdfef00c3'), // Nareszcie!
    10351 => array('hash' => '0591ee73dc0fec66e94e162841ff35378e74fed5'), // MrGinoWOW
    10352 => array('hash' => '70c8a872fad2784eaca0904c03d43acff1358263'), // No stress
    10353 => array('hash' => 'd302bdcb4c33c142254ea4ab7771ddc5d4258bac'), // deFakto deCargo
    10354 => array('hash' => 'b1d8c9fb724c52b7dc6c45a835185c125ff936c5', 9 => 'Polska'), // Azbestowi

);

/* #VEHICLES regexp */
$vehicles = array(
//    'Żuk Strażak' => array('make' => 'Żuk', 'regex' => '(z|ż)uk.*(06|14|15|151)'),
//    'Żuk A07' => array('make' => 'Żuk', 'regex' => '(z|ż)uk.*a.?(07|18)'),
    'Żuk' => array('make' => 'Żuk', 'regex' => '(z|ż)uk'),
    'Polonez Truck' => array('make' => 'Polonez', 'regex' => '(truck|roy)'),
    'Polonez Kombi' => array('make' => 'Polonez', 'regex' => 'pol(dek|onez).*kombi'),
    'Polonez Cargo' => array('make' => 'Polonez', 'regex' => 'cargo'),
    'Polonez Caro' => array('make' => 'Polonez', 'regex' => '(caro)|(gl[ieds])'),
    'Polonez Borewicz' => array('make' => 'Polonez', 'regex' => 'borewicz'),
    'Polonez Atu' => array('make' => 'Polonez', 'regex' => 'atu'),
    'Polonez' => array('make' => 'Polonez', 'regex' => 'pol(dek|onez)'),
    'Skoda/TAZ 1203' => array('make' => 'Skoda', 'regex' => '(koda|taz).*1203'),
    'Skoda Favorit' => array('make' => 'Skoda', 'regex' => 'favorit'),
    'Skoda Forman' => array('make' => 'Skoda', 'regex' => 'forman'),
    'Skoda Rapid' => array('make' => 'Skoda', 'regex' => 'koda.*?rapid'),
    'Skoda 1xx' => array('make' => 'Skoda', 'regex' => 'koda.*1[a-z0-9]{2}'),
    'Skoda' => array('make' => 'Skoda', 'regex' => 'koda'),
    'Łada Niva' => array('make' => 'Łada', 'regex' => 'niva'),
    'VAZ' => array('make' => 'VAZ', 'regex' => 'vaz'),
    'Łada' => array('make' => 'Łada', 'regex' => '(l|ł)ada'),
    'Fiat 125p kombi' => array('make' => 'Fiat', 'regex' => '125.*kombi'),
    'Fiat 125p' => array('make' => 'Fiat', 'regex' => '(fiat 125)|(125 ?p)'),
    'Fiat 127' => array('make' => 'Fiat', 'regex' => '(fiat)? ?127'),
    'Fiat 132p' => array('make' => 'Fiat', 'regex' => 'fiat ?132 ?p?'),
    'Maluch' => array('make' => 'Maluch', 'regex' => '(126|maluch)'),
    'Trabant' => array('make' => 'Trabant', 'regex' => 'trabant'),
    'Wartburg' => array('make' => 'Wartburg', 'regex' => 'wart?burg'),
    'Dacia' => array('make' => 'Dacia', 'regex' => 'dacia'),
    'Nysa 522' => array('make' => 'Nysa', 'regex' => 'nysa.*522'),
    'Nysa' => array('make' => 'Nysa', 'regex' => 'nysa'),
    'Barkas' => array('make' => 'Barkas', 'regex' => 'barkas'),
    'Tavria' => array('make' => 'Tavria', 'regex' => 'tavria'),
    'Warszawa' => array('make' => 'Warszawa', 'regex' => 'warszawa'),
    'Tarpan' => array('make' => 'Tarpan', 'regex' => 'tarpan(.honker)?'),
    'Honker' => array('make' => 'Honker', 'regex' => 'honker'),
    'Lublin III' => array('make' => 'Lublin', 'regex' => 'lublin.*(iii|3)'),
    'Lublin II' => array('make' => 'Lublin', 'regex' => 'lublin.*(ii|2)'),
    'Lublin' => array('make' => 'Lublin', 'regex' => 'lublin'),
    'Avia' => array('make' => 'Avia', 'regex' => 'avia'),
    'UAZ' => array('make' => 'UAZ', 'regex' => 'uaz'),
    'Wołga' => array('make' => 'Wołga', 'regex' => '(gaz.?24)|(wo(l|ł)ga)'),
    'Zastawa' => array('make' => 'Zastawa', 'regex' => 'zasta(v|w)a'),
    'Yugo Koral' => array('make' => 'Yugo Koral', 'regex' => 'koral'),
    'Velorex' => array('make' => 'Velorex', 'regex' => 'velorex'),
    'Moskwicz' => array('make' => 'Moskvitsh', 'regex' => 'mosk(v|w)i(tsh|cz)'),
    'Multicar' => array('make' => 'Multicar', 'regex' => 'multicar'),
    'Star' => array('make' => 'Star', 'regex' => 'star'),
    'Autosan' => array('make' => 'Autosan', 'regex' => 'autosan'),
    'CZ 350' => array('make' => 'CZ', 'regex' => ' ?CZ.*350'),
    'CZ' => array('make' => 'CZ', 'regex' => ' ?CZ '),
    'Jawa 350 TS' => array('make' => 'Jawa', 'regex' => 'jawa (350 ts|ts 350)'),
    'Jawa' => array('make' => 'Jawa', 'regex' => 'jawa'),
    'MZ 250' => array('make' => 'MZ', 'regex' => ' ?MZ.*(250|(jask(o|ó)(l|ł)ka))'),
    'MZ ETZ' => array('make' => 'MZ', 'regex' => '(MZ)? ?ETZ'),
    'MZ TS' => array('make' => 'MZ', 'regex' => '(MZ)? ?TS'),
    'MZ' => array('make' => 'MZ', 'regex' => '^ ?mz ?$'),
    'SHL' => array('make' => 'SHL', 'regex' => 'shl'),
    'WSK' => array('make' => 'WSK', 'regex' => 'wsk'),
    'WFM OSA' => array('make' => 'WFM', 'regex' => 'wfm'),
    'Ural' => array('make' => 'Ural', 'regex' => 'ural'),
    'Romet' => array('make' => 'Romet', 'regex' => 'romet'),
    'Simson' => array('make' => 'Simson', 'regex' => 'simson'),
    'K-650' => array('make' => 'K-650', 'regex' => 'k[ -]?650'),
    'K-750' => array('make' => 'K-750', 'regex' => 'k[ -]?750'),
    '(Niezdecydowani)' => array('make' => '(Niezdecydowani)', 'regex' => '^-$')
);

/* #LOCAL */
$local = '/^\s*(PL|Polska|Poland)\s*$/i';
$regions = array(
     2 => array('name' => 'Dolnośląskie', 'regex' => 'do(l|ł)n(o|y)\w*\W?((s|ś)l(a|ą)sk\w*)?'),
     4 => array('name' => 'Kujawsko-pomorskie', 'regex' => 'kujawsko[ -]{0,3}pomorskie?'),
     6 => array('name' => 'Lubelskie', 'regex' => 'lubel\w*'),
     8 => array('name' => 'Lubuskie', 'regex' => 'lubus\w*'),
    10 => array('name' => 'Łódzkie', 'regex' => '(l|ł)(o|ó)d(z|ź)(kie)?'),
    12 => array('name' => 'Małopolskie', 'regex' => 'ma(ł|l)(e|o)\w*'),
    14 => array('name' => 'Mazowieckie', 'regex' => 'mazow\w*'),
    16 => array('name' => 'Opolskie', 'regex' => '\bopolskie\b'),
    18 => array('name' => 'Podkarpackie', 'regex' => 'podkar\w*'),
    20 => array('name' => 'Podlaskie', 'regex' => 'podlas\w*'),
    22 => array('name' => 'Pomorskie', 'regex' => '(?<!(.o)|(.\-)|(\- )|(o ))pomorskie'),
    24 => array('name' => 'Śląskie', 'regex' => '(?<!(.o)|(.y)|(o )|(y ))(s|ś)(l|ł)(a|ą)sk\w*'),
    26 => array('name' => 'Świętokrzyskie', 'regex' => '(s|ś)wi(e|ę)tokrzyskie'),
    28 => array('name' => 'Warmińsko-mazurskie', 'regex' => 'warmi(n|ń)sko ?-? ?mazurskie?'),
    30 => array('name' => 'Wielkopolskie', 'regex' => '(wielk\w*)|(wlkp)'),
    32 => array('name' => 'Zachodniopomorskie', 'regex' => 'zachodniopomorskie')
);
