#!/usr/bin/php
<?php
$script = $argv[0];
if ($argc < 2){
    echo "Usage: $script htmlfile\n";
    exit(-1);
}

$count = 0;
$users = 0;
$regcnt = -1;
for($i = 1; $i < $argc; $i++){
    $file = $argv[$i];
    if (!file_exists($file)) {
        continue;
    }
    
    // load current file
    $doc = new DOMDocument();
    @$doc->loadHTMLFile($file);
    $dxp = new DOMXPath($doc);
    
    // registered
    $nodes = $dxp->query("//*/znami/strong");
    if ($nodes->length > 0){
        $regcnt = intval($nodes->item(0)->textContent);
    }

    // get total count value
    $classname = "cbUserListResultCount";
    $nodes = $dxp->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' $classname ')]/strong");
    if ($nodes->length < 1)
        echo "No <div class=\"cbUserListResultCount\"> in $file\n";
    $cnt = intval($nodes->item(0)->textContent);
    if ($count > 0 && $count != $cnt)
        echo "Users Total Count diff $count != $cnt in $file\n";
    $count = max($count, $cnt);
    
    // proces list
    $elements = $doc->getElementsByTagName('tbody');
    if (count($elements) < 1){
        echo "No <tbody> in $file\n";
        continue;
    }

    // add users
    $users += $elements->item(0)->childNodes->length;;
}

if ($regcnt >= 0)
    echo("Registered: $regcnt\n");
echo("Users: $count\nList: $users\n");

//echo phpversion()."\n";

?>