function Hash-MD5 ($file) {
	$hasher = [System.Security.Cryptography.MD5]::Create()
	$inputStream = New-Object System.IO.StreamReader ($file)
	$hashBytes = $hasher.ComputeHash($inputStream.BaseStream)
	$builder = New-Object System.Text.StringBuilder
	$hashBytes | Foreach-Object { [void] $builder.Append($_.ToString("X2")) }
	$output = New-Object PsObject
	$output | Add-Member NoteProperty FileName ([string]$file) 
	$output | Add-Member NoteProperty Size ([string]$inputStream.BaseStream.Length) 
	$output | Add-Member NoteProperty HashValue ([string]$builder.ToString())
	$inputStream.Close()
	
	$output
}