#!/usr/bin/php
<?php
$script = $argv[0];
if ($argc < 2){
    echo "Usage: $script htmlfile\n";
    exit(-1);
}

echo("\"Lp.\";\"Id\";\"Team\";\"Pojazd\";\"Uczestnictwo\";\"Skład\";\"Miejscowość\";\"Województwo\";\"Kod Pocztowy\";\"Kraj\";\"AppId\";\"AppCode\";\"Url\"\n");
$format = "%d;%d;\"%s\";\"%s\";\"%s\";\"%s\";\"%s\";\"%s\";\"%s\";\"%s\";\"%s\";\"%s\";\"%s\"\n";

// create context
$cookie = $argv[1];
$ctx = stream_context_create(array(
    'http' => array(
        'method' => "GET",
        'header' => "Cookie: $cookie\r\n"
    )
));

$t = 0;
$count = 0;
$users = 0;
$regcnt = -1;
for($i = 1; $i < $argc; $i++){
    $file = $argv[$i];
    if (!file_exists($file)) {
        continue;
    }

    // load current file
    $doc = new \DOMDocument();
    @$doc->loadHTMLFile($file);
    $dxp = new DOMXPath($doc);

    // registered
    $nodes = $dxp->query("//*/p[@class='rsformznami']");
    if ($nodes->length > 0){
        $regcnt = intval($nodes->item(0)->textContent);
        continue;
    }

    // get total count value
    $classname = "cbUserListResultCount";
    $nodes = $dxp->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' $classname ')]");
    if ($nodes->length < 1)
        fprintf(STDERR, "No <div class=\"cbUserListResultCount\"> in $file\n");
    else if (preg_match('/ma (\d+)/', $nodes->item(0)->textContent, $m))
        $cnt = intval($m[1]);
    else
        $cnt = intval($nodes->item(0)->textContent);

    if ($count > 0 && $count != $cnt)
        echo "Users Total Count diff $count != $cnt in $file\n";
    $count = max($count, @$cnt);

    // proces list
    $classname = "cbUserListFC_avatar";
    $nodes = $dxp->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' $classname ')]/a");
    foreach ($nodes as $a){
        // analyze profile url first
        $url = $a->getAttribute("href");

        // team zlombol id from profile url (if avalible)
        $id = preg_match("/\/(\d+)-/", $url, $m) ? $m[1] : -1;

        // make profile url 'safer'
        $base = basename($url);
        $team = urldecode($base);
        //$url = substr($url, 0, -strlen($base)).rawurlencode($team);

        // simplified name from url
        $name = preg_replace('/\.html$/', '', $team);

        // team name and id from thumbnail (if not found yet)
        $img = $a->getElementsByTagName("img");
        if ($img->length > 0){
            $img = $img->item(0);
            $name = $img->getAttribute("alt");
            if ($id < 0 && preg_match("/\/tn(\d+)_/", $img->getAttribute("src"), $m))
                $id = $m[1];
        }

        // get data from profile
        $extra = getExtra(++$t, $id, $url, $name);
        vprintf($format, $extra);
    }

    // add users
    $users += $nodes->length;;
}

echo("\n");
if ($regcnt >= 0)
    echo("Registered; $regcnt\n");
echo("Users; $count\nOnList; $users\n");

function getExtra($i, $id, $url, $team){
    // get profile content
    global $ctx;
    $profile = @file_get_contents($url, false, $ctx);
    $doc = new DOMDocument();
    @$doc->loadHTML($profile);
    $dxp = new DOMXPath($doc);

    $extra = array();
    $extra[] = $i;

    // zlombol id from contact form (deprecated)
    $nodes = $dxp->query("//*/input[@name = 'pms_uddeimrecip']");
    if ($id < 0 && $nodes->length > 0)
        $extra[] = $nodes->item(0)->getAttribute("value");
    else
        $extra[] = $id;

    $ids = array('name' => 'cbfv_42', 'vehicle' => 'cbfv_55', 'yeara' => 'cbfv_57', 'members' => 'cbfv_54', 'city' => 'cbfv_35', 'region' => 'cbfv_36', 'code' => 'cbfv_37', 'country' => 'cbfv_38', 'appid' => 'cbfv_61', 'appcode' => 'cbfv_60');
    foreach ($ids as $item => $id){
        $nodes = $dxp->query("//*/div[contains(@id, '$id')]");
        if ($nodes->length > 0)
            // addcslashes($str, '"\\/') ???
            $val = str_replace("\"", "\"\"", $nodes->item(0)->textContent);
        else
            $val = ($item == 'name') ? $team : "???";
        $extra[] = $val;

        // zlombol id from appid
        if ($extra[1] < 0 && strlen($val) > 3 && $item == 'appid')
            $extra[1] = preg_replace('/[^0-9]/', '', $val);
    }

    $extra[] = $url;
    return $extra;
}
