#!/usr/bin/php
<?php
$script = $argv[0];
if ($argc < 2){
    echo "Usage: $script htmlfile\n";
    exit(-1);
}

$count = 0;
$users = 0;
$regcnt = -1;
for($i = 1; $i < $argc; $i++){
    $file = $argv[$i];
    if (!file_exists($file)) {
        continue;
    }

    // load current file
    $doc = new DOMDocument();
    @$doc->loadHTMLFile($file);
    $dxp = new DOMXPath($doc);

    // registered
    $nodes = $dxp->query("//*/p[@class='rsformznami']");
    if ($nodes->length > 0){
        $regcnt = intval($nodes->item(0)->textContent);
        continue;
    }

    // get total count value
    $classname = "cbUserListResultCount";
    $nodes = $dxp->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' $classname ')]");
    if ($nodes->length < 1)
        echo "No <div class=\"cbUserListResultCount\"> in $file\n";
    else if (preg_match('/ma (\d+)/', $nodes->item(0)->textContent, $m))
        $cnt = intval($m[1]);

    if ($count > 0 && $count != $cnt)
        echo "Users Total Count diff $count != $cnt in $file\n";
    $count = max($count, $cnt);

    // proces list
    $nodes = $doc->getElementsByTagName('tbody');
    $classname = "cbUserListFC_avatar";
    $nodes = $dxp->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' $classname ')]/a");
    foreach ($nodes as $a){
        $url = $a->getAttribute("href");
        $id = preg_match("/\/(\d+)-/", $url, $m) ? $m[1] : -1;

        // make profile url 'safer'
        $base = basename($url);
        $team = urldecode($base);
        $url = substr($url, 0, -strlen($base)).rawurlencode($team);

        $name = $base = preg_replace('/\.html$/', '', $team); // name from url
        $img = $a->getElementsByTagName("img");
        if ($img->length > 0){
            $img = $img->item(0);
            if ($id < 0 && preg_match("/\/tn(\d+)_/", $img->getAttribute("src"), $m))
                $id = $m[1];

            $name = $img->getAttribute("alt");
        }
        if ($id < 0)
            $id = getId($url, $base);

        echo("$id; $name; $url\n");
    }

    // add users
    $users += $nodes->length;;
}

echo("\n");
if ($regcnt >= 0)
    echo("Registered; $regcnt\n");
echo("Users; $count\nOnList; $users\n");

function getId($url, $base){
    // get profile content
    $profile = file_get_contents($url);
    $doc = new DOMDocument();
    @$doc->loadHTML($profile);
    $dxp = new DOMXPath($doc);

    $nodes = $dxp->query("//*/link[contains(@rel, 'search')]");
    if ($nodes->length > 0 && preg_match("/user\=(\d+)/", $nodes->item(0)->getAttribute("href"), $m))
        return $m[1];

    return is_numeric($base) ? $base : -1;
}
