param([string]$dns, [string[]]$pages=('wp.pl', 'www.interia.pl', 'www.tvn.pl', 'www.google.pl') )
Write-Host "Server: " $dns
foreach($p in $pages){
  $time = @();
  for($i = 0; $i -lt 5; $i++){
    $time = $time + (Measure-Command {nslookup $p $dns 2>&1 | Out-Null}).TotalMilliseconds;
  }
  $m = ($time | Measure-Object -ave -min -max);
  
  Write-Host $p":  "($m.Minimum)", "($m.Maximum)", "($m.Average)"ms"
}
