#!/usr/bin/php
<?php
$script = $argv[0];
if ($argc < 2){
    echo "Usage: $script htmlfile\n";
    exit(-1);
}

$users = 0;
for($i = 1; $i < $argc; $i++){
    $file = $argv[$i];
    if (!file_exists($file)) {
        continue;
    }
    
    $doc = new DOMDocument();
    $doc->loadHTMLFile($file);
    
    $elements = $doc->getElementsByTagName('tbody');
    if (count($elements) < 1){
        echo "No <tbody> in $file\n";
        continue;
    }
    
    $users += $elements->item(0)->childNodes->length;;
}

echo "Users: $users\n";
//echo phpversion()."\n";

?>