$Folder1 = "\\1.1.1.8\e$\My music";
$Folder2 = "M:\My music";

function Get-Directories ($path)
{
    $PathLength = $path.length
    Get-ChildItem $path -Recurse | % {
        Add-Member -InputObject $_ -MemberType NoteProperty -Name RelativePath -Value $_.FullName.substring($PathLength+1)
        $_
    }
}

Compare-Object (Get-Directories $Folder1) (Get-Directories $Folder2) -Property RelativePath, Name, Length |
Sort RelativePath, Name, Length -desc | % {
    if ($file -ne $_.RelativePath) { $_ } } | 
    Where-Object {$_.SideIndicator -eq "<="} | 
    ForEach-Object {
        $file = $_.RelativePath
        Echo F | xcopy "$Folder1\$file" "$Folder2\$file" /S
    }
